/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.errorhandling;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.moskito.core.accumulation.AccumulatorDefinition;
import net.anotheria.moskito.core.accumulation.AccumulatorRepository;
import net.anotheria.moskito.core.config.MoskitoConfigurationHolder;
import net.anotheria.moskito.core.config.errorhandling.ErrorCatcherConfig;
import net.anotheria.moskito.core.config.errorhandling.ErrorHandlingConfig;
import net.anotheria.moskito.core.context.MoSKitoContext;
import net.anotheria.moskito.core.errorhandling.ErrorCatcher;
import net.anotheria.moskito.core.errorhandling.ErrorCatcherBean;
import net.anotheria.moskito.core.errorhandling.ErrorCatcherFactory;
import net.anotheria.moskito.core.helper.AutoTieAbleProducer;
import net.anotheria.moskito.core.predefined.ErrorStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.core.util.AbstractBuiltInProducer;
import net.anotheria.moskito.core.util.AfterStartTasks;
import net.anotheria.moskito.core.util.BuiltInProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BuiltInErrorProducer
extends AbstractBuiltInProducer<ErrorStats>
implements IStatsProducer<ErrorStats>,
BuiltInProducer,
AutoTieAbleProducer {
    private static Logger log = LoggerFactory.getLogger(BuiltInErrorProducer.class);
    private ConcurrentHashMap<Class, ErrorStats> statsMap = null;
    private CopyOnWriteArrayList<ErrorStats> statsList = null;
    private ErrorStats cumulatedStats;
    private boolean errorProducerEnabled = false;
    private static Logger globalErrorLogger = LoggerFactory.getLogger((String)"MoSKitoCaughtErrors");
    private ConcurrentMap<String, List<ErrorCatcher>> catchers = new ConcurrentHashMap<String, List<ErrorCatcher>>();
    private List<ErrorCatcher> defaultCatchers = new CopyOnWriteArrayList<ErrorCatcher>();
    private List<ErrorCatcher> customCatchers = new CopyOnWriteArrayList<ErrorCatcher>();
    private ErrorHandlingConfig errorHandlingConfig = null;

    private BuiltInErrorProducer() {
        this.init();
    }

    private void init() {
        this.errorProducerEnabled = MoskitoConfigurationHolder.getConfiguration().getBuiltinProducersConfig().isErrorProducer();
        this.statsMap = new ConcurrentHashMap();
        this.statsList = new CopyOnWriteArrayList();
        this.cumulatedStats = new ErrorStats("cumulated");
        this.statsList.add(this.cumulatedStats);
        this.catchers = new ConcurrentHashMap<String, List<ErrorCatcher>>();
        if (!this.errorProducerEnabled) {
            return;
        }
        ProducerRegistryFactory.getProducerRegistryInstance().registerProducer(this);
        AfterStartTasks.submitTask(new Runnable(){

            @Override
            public void run() {
                AccumulatorRepository.getInstance().createAccumulator(BuiltInErrorProducer.this.createAccumulatorDefinition("Errors.Cumulated.Total", "total", "cumulated"));
            }
        });
        AfterStartTasks.submitTask(new Runnable(){

            @Override
            public void run() {
                AccumulatorRepository.getInstance().createAccumulator(BuiltInErrorProducer.this.createAccumulatorDefinition("Errors.Cumulated.Initial", "initial", "cumulated"));
            }
        });
        this.errorHandlingConfig = null;
    }

    private AccumulatorDefinition createAccumulatorDefinition(String name, String valueName, String statName) {
        AccumulatorDefinition definition = new AccumulatorDefinition();
        definition.setName(name);
        definition.setProducerName(this.getProducerId());
        definition.setStatName(statName);
        definition.setValueName(valueName);
        definition.setIntervalName(MoskitoConfigurationHolder.getConfiguration().getErrorHandlingConfig().getAutoChartErrorsInterval());
        return definition;
    }

    public static BuiltInErrorProducer getInstance() {
        return ErrorProducerHolder.instance;
    }

    @Override
    public List<ErrorStats> getStats() {
        return this.statsList;
    }

    @Override
    public String getProducerId() {
        return "ErrorProducer";
    }

    @Override
    public String getCategory() {
        return "errors";
    }

    public void notifyError(Throwable throwable) {
        Class<?> clazz;
        ErrorStats existingStats;
        if (!this.errorProducerEnabled) {
            return;
        }
        if (this.errorHandlingConfig == null) {
            this.errorHandlingConfig = MoskitoConfigurationHolder.getConfiguration().getErrorHandlingConfig();
        }
        if (this.errorHandlingConfig.isCountRethrows() && MoSKitoContext.get().seenErrorAlready(throwable)) {
            this.cumulatedStats.addRethrown();
            Class<?> clazz2 = throwable.getClass();
            ErrorStats existingStats2 = this.statsMap.get(clazz2);
            if (existingStats2 != null) {
                existingStats2.addRethrown();
            } else {
                log.error("This can't happen, existing stats are null for " + throwable.getClass());
            }
            return;
        }
        boolean isInitialError = !MoSKitoContext.get().markErrorAndReturnIfErrorAlreadyHappenedBefore();
        this.cumulatedStats.addError(isInitialError);
        if (this.errorHandlingConfig.isLogErrors()) {
            globalErrorLogger.error("auto-caught: " + throwable.getMessage(), throwable);
        }
        for (ErrorCatcher errorCatcher : this.defaultCatchers) {
            errorCatcher.add(throwable);
        }
        for (ErrorCatcher errorCatcher : this.customCatchers) {
            errorCatcher.add(throwable);
        }
        List perExceptionCatchers = (List)this.catchers.get(throwable.getClass().getName());
        if (perExceptionCatchers != null && perExceptionCatchers.size() > 0) {
            for (ErrorCatcher catcher : perExceptionCatchers) {
                catcher.add(throwable);
            }
        }
        if ((existingStats = this.statsMap.get(clazz = throwable.getClass())) != null) {
            existingStats.addError(isInitialError);
            return;
        }
        ErrorStats newErrorStatsObject = new ErrorStats(clazz.getSimpleName());
        ErrorStats oldErrorStatsObject = this.statsMap.putIfAbsent(clazz, newErrorStatsObject);
        if (oldErrorStatsObject != null) {
            oldErrorStatsObject.addError(isInitialError);
            return;
        }
        newErrorStatsObject.addError(isInitialError);
        this.statsList.add(newErrorStatsObject);
        if (this.errorHandlingConfig.isAutoChartErrors()) {
            String chartName = throwable.getClass().getSimpleName();
            AccumulatorRepository.getInstance().createAccumulator(this.createAccumulatorDefinition("Errors." + chartName + ".Total", "total", chartName));
            AccumulatorRepository.getInstance().createAccumulator(this.createAccumulatorDefinition("Errors." + chartName + ".Initial", "initial", chartName));
        }
    }

    ErrorStats testingGetStatsForError(Class errorClazz) {
        return this.statsMap.get(errorClazz);
    }

    ErrorStats testingGetCumulatedStats() {
        return this.cumulatedStats;
    }

    void testingReset() {
        this.init();
    }

    public void afterConfiguration(ErrorHandlingConfig errorHandlingConfig) {
        ErrorCatcherConfig[] catcherConfigs;
        if (!this.errorProducerEnabled) {
            return;
        }
        this.errorHandlingConfig = errorHandlingConfig;
        ErrorCatcherConfig[] defaultCatcherConfigs = errorHandlingConfig.getDefaultCatchers();
        if (defaultCatcherConfigs != null && defaultCatcherConfigs.length > 0) {
            this.defaultCatchers = new CopyOnWriteArrayList<ErrorCatcher>();
            for (ErrorCatcherConfig c : defaultCatcherConfigs) {
                this.defaultCatchers.add(ErrorCatcherFactory.createErrorCatcher(c));
            }
        }
        if ((catcherConfigs = errorHandlingConfig.getCatchers()) != null && catcherConfigs.length > 0) {
            this.catchers = new ConcurrentHashMap<String, List<ErrorCatcher>>();
            for (ErrorCatcherConfig c : catcherConfigs) {
                ErrorCatcher catcher = ErrorCatcherFactory.createErrorCatcher(c);
                LinkedList<ErrorCatcher> catcherList = (LinkedList<ErrorCatcher>)this.catchers.get(c.getExceptionClazz());
                if (catcherList == null) {
                    catcherList = new LinkedList<ErrorCatcher>();
                    this.catchers.put(c.getExceptionClazz(), catcherList);
                }
                catcherList.add(catcher);
            }
        }
    }

    boolean wouldCatch(Class c) {
        if (this.defaultCatchers != null && this.defaultCatchers.size() > 0) {
            return true;
        }
        List errorCatcherList = (List)this.catchers.get(c.getName());
        return errorCatcherList != null && errorCatcherList.size() > 0;
    }

    public List<ErrorCatcherBean> getErrorCatcherBeans() {
        LinkedList<ErrorCatcherBean> ret = new LinkedList<ErrorCatcherBean>();
        for (ErrorCatcher errorCatcher : this.defaultCatchers) {
            ret.add(this.makeErrorCatcherBean(errorCatcher, ErrorCatcherBean.ErrorCatcherType.DEFAULT));
        }
        for (ErrorCatcher errorCatcher : this.customCatchers) {
            ret.add(this.makeErrorCatcherBean(errorCatcher, ErrorCatcherBean.ErrorCatcherType.CUSTOM));
        }
        for (Map.Entry entry : this.catchers.entrySet()) {
            for (ErrorCatcher c : (List)entry.getValue()) {
                ret.add(this.makeErrorCatcherBean(c, ErrorCatcherBean.ErrorCatcherType.EXCEPTION_BOUND));
            }
        }
        return ret;
    }

    private ErrorCatcherBean makeErrorCatcherBean(ErrorCatcher c, ErrorCatcherBean.ErrorCatcherType type) {
        ErrorCatcherBean ret = new ErrorCatcherBean();
        ret.setType(type);
        ret.setName(c.getName());
        ret.setNumberOfCaughtErrors(c.getNumberOfCaughtErrors());
        ret.setTarget(c.getConfig().getTarget());
        ret.setParameter(c.getConfig().getParameter());
        return ret;
    }

    public ErrorCatcher getCatcher(String name, String type) {
        ErrorCatcherBean.ErrorCatcherType catcherType = ErrorCatcherBean.ErrorCatcherType.valueOf(type);
        switch (catcherType) {
            case DEFAULT: {
                return this.getCatcherFromDefaultCatchers(name);
            }
            case EXCEPTION_BOUND: {
                return this.getCatcherForException(name);
            }
        }
        throw new IllegalArgumentException("Returning catchers of type " + type + ",name: " + name + " not supported yet");
    }

    private ErrorCatcher getCatcherForException(String name) {
        List catchersByName = (List)this.catchers.get(name);
        if (catchersByName == null) {
            throw new IllegalArgumentException("Catcher: " + name + " not found");
        }
        return (ErrorCatcher)catchersByName.get(0);
    }

    private ErrorCatcher getCatcherFromDefaultCatchers(String name) {
        for (ErrorCatcher c : this.defaultCatchers) {
            if (c.getName() == null || !c.getName().equals(name)) continue;
            return c;
        }
        throw new IllegalArgumentException("Catcher: " + name + " not found");
    }

    public void addCustomErrorCatcher(ErrorCatcher catcher) {
        this.customCatchers.add(catcher);
    }

    private static class ErrorProducerHolder {
        static BuiltInErrorProducer instance = new BuiltInErrorProducer();

        private ErrorProducerHolder() {
        }
    }
}

