/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.errorhandling;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.moskito.core.config.MoskitoConfigurationHolder;
import net.anotheria.moskito.core.config.errorhandling.ErrorCatcherConfig;
import net.anotheria.moskito.core.errorhandling.CaughtError;
import net.anotheria.moskito.core.errorhandling.ErrorCatcher;
import net.anotheria.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuiltinErrorCatcher
implements ErrorCatcher {
    private volatile List<CaughtError> errorList = new CopyOnWriteArrayList<CaughtError>();
    private ErrorCatcherConfig config;
    private String name;
    private volatile Logger log = null;

    BuiltinErrorCatcher(ErrorCatcherConfig aConfig) {
        this.config = aConfig;
        this.name = this.extractName(this.config.getExceptionClazz());
        if (aConfig.getTarget().log()) {
            this.log = LoggerFactory.getLogger((String)this.config.getParameter());
        }
    }

    @Override
    public void add(Throwable throwable) {
        if (this.config.getTarget().log()) {
            this.log.error("caught " + throwable.getClass(), throwable);
        }
        if (this.config.getTarget().keepInMemory()) {
            int limit = MoskitoConfigurationHolder.getConfiguration().getErrorHandlingConfig().getCatchersMemoryErrorLimit();
            int tolerableLimit = (int)((double)limit * 1.1);
            if (this.errorList.size() > tolerableLimit) {
                this.trimList(limit);
            }
            this.errorList.add(new CaughtError(throwable));
        }
    }

    @Override
    public List<CaughtError> getErrorList() {
        return this.errorList;
    }

    synchronized void trimList(int toLimit) {
        int listSize = this.errorList.size();
        CopyOnWriteArrayList<CaughtError> newList = new CopyOnWriteArrayList<CaughtError>();
        for (int i = listSize - toLimit; i < listSize; ++i) {
            newList.add(this.errorList.get(i));
        }
        this.errorList = newList;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private String extractName(String className) {
        String[] tokens = StringUtils.tokenize((String)className, (char)'.');
        if (tokens.length == 1) {
            return tokens[0];
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < tokens.length - 1; ++i) {
            ret.append(tokens[i]).append('.');
        }
        ret.append(tokens[tokens.length - 1]);
        return ret.toString();
    }

    @Override
    public int getNumberOfCaughtErrors() {
        return this.errorList.size();
    }

    @Override
    public ErrorCatcherConfig getConfig() {
        return this.config;
    }
}

