/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.helper;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.moskito.core.helper.AutoTieWrapper;
import net.anotheria.moskito.core.helper.IntervalUpdateable;
import net.anotheria.moskito.core.helper.Tieable;
import net.anotheria.moskito.core.stats.IIntervalListener;
import net.anotheria.moskito.core.stats.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntervalListener
implements IIntervalListener {
    private static Logger log = LoggerFactory.getLogger(IntervalListener.class);
    private List<IntervalUpdateable> updateables = new CopyOnWriteArrayList<IntervalUpdateable>();

    @Override
    public void intervalUpdated(Interval aCaller) {
        for (IntervalUpdateable u : this.updateables) {
            try {
                u.update();
            }
            catch (Exception e) {
                log.warn("IntervalUpdateable " + u + " update failed, skipping ", (Throwable)e);
            }
        }
    }

    public void addTieable(Tieable toAdd) {
        this.updateables.add(toAdd);
    }

    public void removeTieable(Tieable toRemove) {
        this.updateables.remove(toRemove);
    }

    public void addTieableAutoTieWrapper(AutoTieWrapper toAdd) {
        this.updateables.add(toAdd);
    }
}

