/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.helper;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.moskito.core.helper.AutoTieWrapper;
import net.anotheria.moskito.core.helper.IntervalListener;
import net.anotheria.moskito.core.helper.NoIntervalListener;
import net.anotheria.moskito.core.helper.Tieable;
import net.anotheria.moskito.core.helper.TieableDefinition;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.IProducerRegistry;
import net.anotheria.moskito.core.registry.IProducerRegistryListener;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.UnknownIntervalException;
import net.anotheria.moskito.core.stats.impl.IntervalRegistry;
import net.anotheria.moskito.core.timing.IUpdateable;
import net.anotheria.moskito.core.timing.UpdateTriggerServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TieableRepository<T extends Tieable, S extends IStats>
implements IProducerRegistryListener<S>,
IUpdateable {
    private ConcurrentMap<String, IntervalListener> listeners = new ConcurrentHashMap<String, IntervalListener>();
    private final IProducerRegistry registry = ProducerRegistryFactory.getProducerRegistryInstance();
    private static Logger log = LoggerFactory.getLogger(TieableRepository.class);
    private ConcurrentMap<String, T> tieables = new ConcurrentHashMap<String, T>();
    private final IntervalListener defaultListener = new IntervalListener();
    private List<T> yetUntied = new CopyOnWriteArrayList<T>();
    private ConcurrentMap<String, String> id2nameMapping = new ConcurrentHashMap<String, String>();

    public TieableRepository() {
        ProducerRegistryFactory.getProducerRegistryInstance().addListener(this);
        this.listeners.put("default", this.defaultListener);
        UpdateTriggerServiceFactory.getUpdateTriggerService().addUpdateable(this, 60);
    }

    protected void addUntied(T t) {
        this.yetUntied.add(t);
    }

    protected void addToAutoTie(T tieable, IStatsProducer<?> producer) {
        AutoTieWrapper wrapper = new AutoTieWrapper((Tieable)tieable, (IStatsProducer<? extends IStats>)producer);
        if (tieable.getDefinition().getIntervalName() != null) {
            IntervalListener listener = this.getListener(tieable.getDefinition().getIntervalName());
            listener.addTieableAutoTieWrapper(wrapper);
        }
    }

    private IntervalListener getListener(String intervalName) {
        IntervalListener listener = (IntervalListener)this.listeners.get(intervalName);
        if (listener != null) {
            return listener;
        }
        try {
            Interval interval = IntervalRegistry.getInstance().getIntervalOnlyIfExisting(intervalName);
            listener = new IntervalListener();
            IntervalListener old = this.listeners.putIfAbsent(intervalName, listener);
            if (old != null) {
                return old;
            }
            interval.addSecondaryIntervalListener(listener);
            return listener;
        }
        catch (UnknownIntervalException e) {
            return NoIntervalListener.INSTANCE;
        }
    }

    @Override
    public void notifyProducerRegistered(IStatsProducer<S> producer) {
        ArrayList<T> tmpList = new ArrayList<T>(this.yetUntied);
        for (Tieable t : tmpList) {
            if (!t.getDefinition().getProducerName().equals(producer.getProducerId())) continue;
            try {
                if (!this.tie(t, producer)) continue;
                this.yetUntied.remove(t);
            }
            catch (Exception e) {
                log.error("notifyProducerRegistered(" + producer + ')', (Throwable)e);
            }
        }
    }

    @Override
    public void notifyProducerUnregistered(IStatsProducer<S> producer) {
    }

    protected abstract boolean tie(T var1, IStatsProducer<? extends IStats> var2);

    protected IProducerRegistry getRegistry() {
        return this.registry;
    }

    protected void detachFromListener(T t) {
        if (t.getDefinition().getIntervalName() != null) {
            IntervalListener listener = this.getListener(t.getDefinition().getIntervalName());
            listener.removeTieable((Tieable)t);
        }
    }

    protected void attachToListener(T t) {
        if (t.getDefinition().getIntervalName() != null) {
            IntervalListener listener = this.getListener(t.getDefinition().getIntervalName());
            listener.addTieable((Tieable)t);
        }
    }

    public List<T> getTieables() {
        ArrayList ret = new ArrayList(this.tieables.size());
        ret.addAll(this.tieables.values());
        return ret;
    }

    protected abstract T create(TieableDefinition var1);

    public T createTieable(TieableDefinition definition) {
        T t = this.create(definition);
        String name = t.getName();
        int i = 1;
        while (this.tieables.get(name) != null) {
            name = t.getName() + '-' + i++;
        }
        definition.setName(name);
        this.tieables.put(t.getName(), t);
        this.attachToListener(t);
        IStatsProducer producer = this.getRegistry().getProducer(definition.getProducerName());
        if (producer != null) {
            this.tie(t, producer);
        } else {
            this.addUntied(t);
        }
        this.id2nameMapping.put(t.getId(), t.getName());
        return t;
    }

    public void removeById(String id) {
        String name = (String)this.id2nameMapping.get(id);
        if (name == null) {
            throw new IllegalArgumentException("Id: " + id + " not found");
        }
        this.removeTieable(name);
    }

    public void removeTieable(String name) {
        Tieable t = (Tieable)this.tieables.remove(name);
        if (t == null) {
            return;
        }
        this.detachFromListener(t);
        try {
            this.yetUntied.remove(t);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void addTieable(T tieable) {
        this.tieables.put(tieable.getName(), tieable);
        this.id2nameMapping.put(tieable.getId(), tieable.getName());
    }

    public void removeTieable(TieableDefinition def) {
        this.removeTieable(def.getName());
    }

    public T getByName(String name) {
        return (T)((Tieable)this.tieables.get(name));
    }

    @Override
    public void update() {
        this.defaultListener.intervalUpdated(null);
    }

    public T getById(String id) {
        String name = (String)this.id2nameMapping.get(id);
        if (name == null) {
            throw new IllegalArgumentException("Id: " + id + " not found");
        }
        return this.getByName(name);
    }

    protected void cleanup() {
        this.id2nameMapping.clear();
        this.tieables.clear();
    }

    public List<String> getIdsByProducerId(String producerId) {
        if (producerId == null || producerId.length() == 0) {
            throw new IllegalArgumentException("ProducerId is null or empty (" + producerId + ")");
        }
        LinkedList<String> ret = new LinkedList<String>();
        for (Map.Entry entry : ((ConcurrentHashMap)this.tieables).entrySet()) {
            String aProducerId = ((Tieable)entry.getValue()).getDefinition().getProducerName();
            if (aProducerId == null || !aProducerId.equals(producerId)) continue;
            ret.add((String)entry.getKey());
        }
        return ret;
    }
}

