/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.journey;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.anotheria.moskito.core.journey.Journey;
import net.anotheria.moskito.core.journey.JourneyManager;
import net.anotheria.moskito.core.journey.NoSuchJourneyException;

public class JourneyManagerImpl
implements JourneyManager {
    private Map<String, Journey> journeys = new ConcurrentHashMap<String, Journey>();

    JourneyManagerImpl() {
    }

    @Override
    public Journey createJourney(String name) {
        Journey s = new Journey(name);
        this.journeys.put(s.getName(), s);
        return s;
    }

    @Override
    public Journey getJourney(String name) throws NoSuchJourneyException {
        Journey s = this.journeys.get(name);
        if (s == null) {
            throw new NoSuchJourneyException(name);
        }
        return s;
    }

    @Override
    public Journey getOrCreateJourney(String name) {
        Journey s = this.journeys.get(name);
        if (s != null) {
            return s;
        }
        s = new Journey(name);
        this.journeys.put(s.getName(), s);
        return s;
    }

    @Override
    public List<Journey> getJourneys() {
        ArrayList<Journey> ret = new ArrayList<Journey>(this.journeys.values());
        return ret;
    }

    @Override
    public void removeJourney(Journey journey) {
        this.removeJourney(journey.getName());
    }

    @Override
    public void removeJourney(String name) {
        this.journeys.remove(name);
    }
}

