/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.logging;

import java.util.List;
import net.anotheria.moskito.core.config.MoskitoConfigurationHolder;
import net.anotheria.moskito.core.logging.DefaultStatsLogger;
import net.anotheria.moskito.core.logging.IntervalStatsLogger;
import net.anotheria.moskito.core.logging.SLF4JLogOutput;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.stats.impl.IntervalRegistry;
import org.slf4j.LoggerFactory;

public final class LoggerUtil {
    private LoggerUtil() {
    }

    public static final void createSLF4JIntervalStatsLoggerForAllConfiguredIntervals(IStatsProducer producer) {
        LoggerUtil.createSLF4JIntervalStatsLoggerForAllConfiguredIntervals(producer, "Moskito");
    }

    public static final void createSLF4JIntervalStatsLoggerForAllConfiguredIntervals(IStatsProducer producer, String loggerNamePrefix) {
        List<String> configuredIntervals = MoskitoConfigurationHolder.getConfiguration().getConfiguredIntervalNames();
        for (String intervalName : configuredIntervals) {
            new IntervalStatsLogger(producer, IntervalRegistry.getInstance().getInterval(intervalName), new SLF4JLogOutput(LoggerFactory.getLogger((String)(loggerNamePrefix + intervalName))));
        }
    }

    public static final void createSLF4JDefaultStatsLogger(IStatsProducer producer) {
        LoggerUtil.createSLF4JDefaultStatsLogger(producer, "MoskitoDefault");
    }

    public static final void createSLF4JDefaultStatsLogger(IStatsProducer producer, String loggerName) {
        new DefaultStatsLogger(producer, new SLF4JLogOutput(LoggerFactory.getLogger((String)loggerName)));
    }

    public static final void createSLF4JDefaultAndIntervalStatsLogger(IStatsProducer producer) {
        LoggerUtil.createSLF4JDefaultAndIntervalStatsLogger(producer, "Moskito");
    }

    public static final void createSLF4JDefaultAndIntervalStatsLogger(IStatsProducer producer, String loggerNamePrefix) {
        LoggerUtil.createSLF4JDefaultStatsLogger(producer, loggerNamePrefix + "Default");
        LoggerUtil.createSLF4JIntervalStatsLoggerForAllConfiguredIntervals(producer, loggerNamePrefix);
    }
}

