/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.predefined;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.producers.AbstractStats;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.moskito.core.stats.impl.StatValueFactory;

public class CacheStats
extends AbstractStats {
    private StatValue requests;
    private StatValue hits;
    private StatValue writes;
    private StatValue garbageCollected;
    private StatValue rolloverCount;
    private StatValue expiredCount;
    private StatValue filteredCount;
    private StatValue cacheFullCount;
    private StatValue deletes;
    private String name;
    private static final List<String> VALUE_NAMES = Collections.unmodifiableList(Arrays.asList("REQ", "HIT", "HR", "WR", "GC", "RO", "FU", "EX", "DEL", "FI"));

    public CacheStats() {
        this("unnamed", Constants.getDefaultIntervals());
    }

    public CacheStats(String aName, Interval[] selectedIntervals) {
        Long longPattern = 0L;
        this.name = aName;
        this.requests = StatValueFactory.createStatValue(longPattern, "requests", selectedIntervals);
        this.hits = StatValueFactory.createStatValue(longPattern, "hits", selectedIntervals);
        this.writes = StatValueFactory.createStatValue(longPattern, "writes", selectedIntervals);
        this.garbageCollected = StatValueFactory.createStatValue(longPattern, "gccollects", selectedIntervals);
        this.rolloverCount = StatValueFactory.createStatValue(longPattern, "rollovers", selectedIntervals);
        this.expiredCount = StatValueFactory.createStatValue(longPattern, "expirations", selectedIntervals);
        this.filteredCount = StatValueFactory.createStatValue(longPattern, "filter", selectedIntervals);
        this.cacheFullCount = StatValueFactory.createStatValue(longPattern, "cachefull", selectedIntervals);
        this.deletes = StatValueFactory.createStatValue(longPattern, "deletes", selectedIntervals);
        this.addStatValues(this.requests, this.hits, this.writes, this.garbageCollected, this.rolloverCount, this.expiredCount, this.filteredCount, this.cacheFullCount, this.deletes);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public double getHitRatio(String intervalName) {
        return this.hits.getValueAsDouble(intervalName) / this.requests.getValueAsDouble(intervalName);
    }

    public void addRequest() {
        this.requests.increase();
    }

    public long getRequests(String intervalName) {
        return this.requests.getValueAsLong(intervalName);
    }

    public void addHit() {
        this.hits.increase();
    }

    public long getHits(String intervalName) {
        return this.hits.getValueAsLong(intervalName);
    }

    public void addHitRequest() {
        this.requests.increase();
        this.hits.increase();
    }

    public void addWrite() {
        this.writes.increase();
    }

    public long getWrites(String intervalName) {
        return this.writes.getValueAsLong(intervalName);
    }

    public void addDelete() {
        this.deletes.increase();
    }

    public long getDeletes(String intervalName) {
        return this.deletes.getValueAsLong(intervalName);
    }

    public void addRollover() {
        this.rolloverCount.increase();
    }

    public void addCacheFull() {
        this.cacheFullCount.increase();
    }

    public long getCacheFullCount(String intervalName) {
        return this.cacheFullCount.getValueAsLong(intervalName);
    }

    public long getRolloverCount(String intervalName) {
        return this.rolloverCount.getValueAsLong(intervalName);
    }

    public void addGarbageCollected() {
        this.garbageCollected.increase();
    }

    public long getGarbageCollected(String intervalName) {
        return this.garbageCollected.getValueAsLong(intervalName);
    }

    public void addFiltered() {
        this.filteredCount.increase();
    }

    public long getFiltered(String intervalName) {
        return this.filteredCount.getValueAsLong(intervalName);
    }

    public void addExpired() {
        this.expiredCount.increase();
    }

    public long getExpired(String intervalName) {
        return this.expiredCount.getValueAsLong(intervalName);
    }

    public double getFillRatio(String intervalName) {
        return 0.0;
    }

    @Override
    public List<String> getAvailableValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public String toStatsString(String intervalName, TimeUnit timeUnit) {
        StringBuilder b = new StringBuilder();
        b.append(this.getName()).append(' ');
        b.append(" REQ: ").append(this.requests.getValueAsLong(intervalName));
        b.append(" HIT: ").append(this.hits.getValueAsLong(intervalName));
        b.append(" HR: ").append(this.getHitRatio(intervalName));
        b.append(" WR: ").append(this.writes.getValueAsLong(intervalName));
        b.append(" GC: ").append(this.garbageCollected.getValueAsLong(intervalName));
        b.append(" RO: ").append(this.rolloverCount.getValueAsLong(intervalName));
        b.append(" FU: ").append(this.cacheFullCount.getValueAsLong(intervalName));
        b.append(" EX: ").append(this.expiredCount.getValueAsLong(intervalName));
        b.append(" DEL: ").append(this.deletes.getValueAsLong(intervalName));
        b.append(" FI: ").append(this.filteredCount.getValueAsLong(intervalName));
        return b.toString();
    }

    @Override
    public String getValueByNameAsString(String valueName, String intervalName, TimeUnit timeUnit) {
        if (valueName == null || valueName.isEmpty()) {
            throw new AssertionError((Object)"Value name can not be empty");
        }
        if ((valueName = valueName.toLowerCase()).equals("req")) {
            return String.valueOf(this.requests.getValueAsLong(intervalName));
        }
        if (valueName.equals("hit")) {
            return String.valueOf(this.hits.getValueAsLong(intervalName));
        }
        if (valueName.equals("hr")) {
            return String.valueOf(this.getHitRatio(intervalName));
        }
        if (valueName.equals("wr")) {
            return String.valueOf(this.writes.getValueAsLong(intervalName));
        }
        if (valueName.equals("gc")) {
            return String.valueOf(this.garbageCollected.getValueAsLong(intervalName));
        }
        if (valueName.equals("ro")) {
            return String.valueOf(this.rolloverCount.getValueAsLong(intervalName));
        }
        if (valueName.equals("fu")) {
            return String.valueOf(this.cacheFullCount.getValueAsLong(intervalName));
        }
        if (valueName.equals("ex")) {
            return String.valueOf(this.expiredCount.getValueAsLong(intervalName));
        }
        if (valueName.equals("del")) {
            return String.valueOf(this.deletes.getValueAsLong(intervalName));
        }
        if (valueName.equals("fi")) {
            return String.valueOf(this.filteredCount.getValueAsLong(intervalName));
        }
        return super.getValueByNameAsString(valueName, intervalName, timeUnit);
    }
}

