/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.predefined;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.producers.AbstractStats;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.moskito.core.stats.impl.StatValueFactory;

public class ErrorStats
extends AbstractStats {
    private StatValue initial;
    private StatValue total;
    private StatValue rethrown;
    private StatValue maxInitial;
    private StatValue maxRethrown;
    private StatValue maxTotal;
    private static final List<String> VALUE_NAMES = Collections.unmodifiableList(Arrays.asList("INITIAL", "TOTAL", "RETHROWN", "MAXINITIAL", "MAXTOTAL", "MAXRETHROWN"));

    public ErrorStats() {
        this("unnamed", Constants.getDefaultIntervals());
    }

    public ErrorStats(String aName) {
        this(aName, Constants.getDefaultIntervals());
    }

    public ErrorStats(String aName, Interval[] selectedIntervals) {
        super(aName);
        Integer pattern = 0;
        this.total = StatValueFactory.createStatValue(pattern, "total", selectedIntervals);
        this.initial = StatValueFactory.createStatValue(pattern, "initial", selectedIntervals);
        this.rethrown = StatValueFactory.createStatValue(pattern, "rethrown", selectedIntervals);
        this.maxTotal = StatValueFactory.createStatValue(pattern, "maxTotal", selectedIntervals);
        this.maxInitial = StatValueFactory.createStatValue(pattern, "maxInitial", selectedIntervals);
        this.maxRethrown = StatValueFactory.createStatValue(pattern, "maxRethrown", selectedIntervals);
        this.addStatValues(this.initial, this.total, this.rethrown, this.maxInitial, this.maxTotal, this.maxRethrown);
    }

    @Override
    public List<String> getAvailableValueNames() {
        return VALUE_NAMES;
    }

    @Override
    public String toStatsString(String intervalName, TimeUnit timeUnit) {
        StringBuilder b = new StringBuilder();
        b.append(this.getName()).append(' ');
        b.append(" INITIAL: ").append(this.initial.getValueAsLong(intervalName));
        b.append(" TOTAL: ").append(this.total.getValueAsLong(intervalName));
        b.append(" RETHROWN: ").append(this.total.getValueAsLong(intervalName));
        b.append(" MAX INITIAL: ").append(this.maxInitial.getValueAsLong(intervalName));
        b.append(" MAX TOTAL: ").append(this.maxTotal.getValueAsLong(intervalName));
        b.append(" MAX RETHROWN: ").append(this.maxTotal.getValueAsLong(intervalName));
        return b.toString();
    }

    @Override
    public String getValueByNameAsString(String valueName, String intervalName, TimeUnit timeUnit) {
        if (valueName == null || valueName.isEmpty()) {
            throw new AssertionError((Object)"Value name can not be empty");
        }
        if ((valueName = valueName.toLowerCase()).equals("initial")) {
            return String.valueOf(this.initial.getValueAsLong(intervalName));
        }
        if (valueName.equals("total")) {
            return String.valueOf(this.total.getValueAsLong(intervalName));
        }
        if (valueName.equals("rethrown")) {
            return String.valueOf(this.rethrown.getValueAsLong(intervalName));
        }
        if (valueName.equals("maxinitial")) {
            return String.valueOf(this.maxInitial.getValueAsLong(intervalName));
        }
        if (valueName.equals("maxtotal")) {
            return String.valueOf(this.maxTotal.getValueAsLong(intervalName));
        }
        if (valueName.equals("maxrethrown")) {
            return String.valueOf(this.maxRethrown.getValueAsLong(intervalName));
        }
        return super.getValueByNameAsString(valueName, intervalName, timeUnit);
    }

    public void addError(boolean isInitialError) {
        this.total.increase();
        this.maxTotal.setValueIfGreaterThanCurrentAsLong(this.total.getValueAsLong());
        if (isInitialError) {
            this.initial.increase();
            this.maxInitial.setValueIfGreaterThanCurrentAsLong(this.initial.getValueAsLong());
        }
    }

    public void addRethrown() {
        this.rethrown.increase();
        this.maxRethrown.setValueIfGreaterThanCurrentAsLong(this.rethrown.getValueAsLong());
    }

    public int getInitial() {
        return this.initial.getValueAsInt();
    }

    public int getTotal() {
        return this.total.getValueAsInt();
    }

    public int getRethrown() {
        return this.rethrown.getValueAsInt();
    }

    public int getInitial(String intervalName) {
        return this.initial.getValueAsInt(intervalName);
    }

    public int getTotal(String intervalName) {
        return this.total.getValueAsInt(intervalName);
    }

    public int getRethrown(String intervalName) {
        return this.rethrown.getValueAsInt(intervalName);
    }

    public int getMaxInitial() {
        return this.maxInitial.getValueAsInt();
    }

    public int getMaxTotal() {
        return this.maxTotal.getValueAsInt();
    }

    public int getMaxInitial(String intervalName) {
        return this.maxInitial.getValueAsInt(intervalName);
    }

    public int getMaxTotal(String intervalName) {
        return this.maxTotal.getValueAsInt(intervalName);
    }

    public int getMaxRethrown() {
        return this.maxRethrown.getValueAsInt();
    }

    public int getMaxRethrown(String intervalName) {
        return this.maxRethrown.getValueAsInt(intervalName);
    }

    @Override
    public String toString() {
        return this.toStatsString();
    }
}

