/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.predefined;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.producers.AbstractStats;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.StatValueTypes;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.moskito.core.stats.impl.StatValueFactory;

public class GCStats
extends AbstractStats {
    private final StatValue collectionCount;
    private final StatValue collectionTime;
    private static final List<String> VALUE_NAMES = Collections.unmodifiableList(Arrays.asList("CollectionCount", "CollectionTime"));

    public GCStats(String aName) {
        this(aName, Constants.getDefaultIntervals());
    }

    private GCStats(String aName, Interval[] selectedIntervals) {
        super(aName);
        this.collectionCount = StatValueFactory.createStatValue(StatValueTypes.DIFFLONG, "collectionCount", selectedIntervals);
        this.collectionTime = StatValueFactory.createStatValue(StatValueTypes.DIFFLONG, "collectionTime", selectedIntervals);
        this.addStatValues(this.collectionCount, this.collectionTime);
    }

    @Override
    public String toStatsString(String intervalName, TimeUnit unit) {
        StringBuilder ret = new StringBuilder();
        ret.append(this.getName()).append(' ');
        ret.append(" CollectionCount: ").append(this.collectionCount.getValueAsLong(intervalName));
        ret.append(" CollectionTime: ").append(this.collectionTime.getValueAsLong(intervalName));
        return ret.toString();
    }

    @Override
    public String getValueByNameAsString(String valueName, String intervalName, TimeUnit timeUnit) {
        if (valueName == null) {
            throw new AssertionError((Object)"Value name can't be null");
        }
        if ((valueName = valueName.toLowerCase()).equals("collectioncount") || valueName.equals("collection count")) {
            return String.valueOf(this.getCollectionCount(intervalName));
        }
        if (valueName.equals("collectiontime") || valueName.equals("collection time")) {
            return String.valueOf(this.getCollectionTime(intervalName));
        }
        return super.getValueByNameAsString(valueName, intervalName, timeUnit);
    }

    @Override
    public List<String> getAvailableValueNames() {
        return VALUE_NAMES;
    }

    public void update(long aCollectionCount, long aCollectionTime) {
        this.collectionCount.setValueAsLong(aCollectionCount);
        this.collectionTime.setValueAsLong(aCollectionTime);
    }

    public long getCollectionCount(String intervalName) {
        return this.collectionCount.getValueAsLong(intervalName);
    }

    public long getCollectionTime(String intervalName) {
        return this.collectionTime.getValueAsLong(intervalName);
    }
}

