/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.predefined;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.anotheria.moskito.core.decorators.DecoratorRegistryFactory;
import net.anotheria.moskito.core.decorators.IDecorator;
import net.anotheria.moskito.core.decorators.predefined.GlobalRequestProcessorStatsDecorator;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.producers.AbstractStats;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.StatValueTypes;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.moskito.core.stats.impl.StatValueFactory;
import net.anotheria.moskito.core.util.MoskitoWebUi;

public class GlobalRequestProcessorStats
extends AbstractStats {
    private final StatValue requestCount;
    private final StatValue maxTime;
    private final StatValue bytesReceived;
    private final StatValue bytesSent;
    private final StatValue processingTime;
    private final StatValue errorCount;
    private static final List<String> VALUE_NAMES;

    public GlobalRequestProcessorStats(String aName) {
        this(aName, Constants.getDefaultIntervals());
    }

    private GlobalRequestProcessorStats(String aName, Interval[] selectedIntervals) {
        super(aName);
        this.requestCount = StatValueFactory.createStatValue(StatValueTypes.DIFFLONG, "requestCount", selectedIntervals);
        this.maxTime = StatValueFactory.createStatValue(StatValueTypes.DIFFLONG, "maxTime", selectedIntervals);
        this.bytesReceived = StatValueFactory.createStatValue(StatValueTypes.DIFFLONG, "bytesReceived", selectedIntervals);
        this.bytesSent = StatValueFactory.createStatValue(StatValueTypes.DIFFLONG, "bytesSent", selectedIntervals);
        this.processingTime = StatValueFactory.createStatValue(StatValueTypes.DIFFLONG, "processingTime", selectedIntervals);
        this.errorCount = StatValueFactory.createStatValue(StatValueTypes.DIFFLONG, "errorCount", selectedIntervals);
        this.addStatValues(this.requestCount, this.maxTime, this.bytesReceived, this.bytesSent, this.processingTime, this.errorCount);
    }

    @Override
    public String toStatsString(String intervalName, TimeUnit unit) {
        StringBuilder ret = new StringBuilder();
        ret.append(this.getName()).append(' ');
        ret.append(" RequestCount: ").append(this.requestCount.getValueAsLong(intervalName));
        ret.append(" MaxTime: ").append(this.maxTime.getValueAsLong(intervalName));
        ret.append(" BytesReceived: ").append(this.bytesReceived.getValueAsLong(intervalName));
        ret.append(" BytesSent: ").append(this.bytesSent.getValueAsLong(intervalName));
        ret.append(" ProcessingTime: ").append(this.processingTime.getValueAsLong(intervalName));
        ret.append(" ErrorCount: ").append(this.errorCount.getValueAsLong(intervalName));
        return ret.toString();
    }

    @Override
    public String getValueByNameAsString(String valueName, String intervalName, TimeUnit timeUnit) {
        if (valueName == null) {
            throw new AssertionError((Object)"Value name can't be null");
        }
        if ((valueName = valueName.toLowerCase()).equals("requestcount") || valueName.equals("request count")) {
            return String.valueOf(this.getRequestCount(intervalName));
        }
        if (valueName.equals("maxtime") || valueName.equals("max time")) {
            return String.valueOf(this.getMaxTime(intervalName));
        }
        if (valueName.equals("bytesreceived") || valueName.equals("bytes received")) {
            return String.valueOf(this.getBytesReceived(intervalName));
        }
        if (valueName.equals("bytessent") || valueName.equals("bytes sent")) {
            return String.valueOf(this.getBytesSent(intervalName));
        }
        if (valueName.equals("processingtime") || valueName.equals("processing time")) {
            return String.valueOf(this.getProcessingTime(intervalName));
        }
        if (valueName.equals("errorcount") || valueName.equals("error count")) {
            return String.valueOf(this.getErrorCount(intervalName));
        }
        return super.getValueByNameAsString(valueName, intervalName, timeUnit);
    }

    @Override
    public List<String> getAvailableValueNames() {
        return VALUE_NAMES;
    }

    public void update(long aRequestCount, long aMaxTime, long aBytesReceived, long aBytesSent, long aProcessingTime, long aErrorCount) {
        this.requestCount.setValueAsLong(aRequestCount);
        this.maxTime.setValueAsLong(aMaxTime);
        this.bytesReceived.setValueAsLong(aBytesReceived);
        this.bytesSent.setValueAsLong(aBytesSent);
        this.processingTime.setValueAsLong(aProcessingTime);
        this.errorCount.setValueAsLong(aErrorCount);
    }

    public long getRequestCount(String intervalName) {
        return this.requestCount.getValueAsLong(intervalName);
    }

    public long getMaxTime(String intervalName) {
        return this.maxTime.getValueAsLong(intervalName);
    }

    public long getBytesReceived(String intervalName) {
        return this.bytesReceived.getValueAsLong(intervalName);
    }

    public long getBytesSent(String intervalName) {
        return this.bytesSent.getValueAsLong(intervalName);
    }

    public long getProcessingTime(String intervalName) {
        return this.processingTime.getValueAsLong(intervalName);
    }

    public long getErrorCount(String intervalName) {
        return this.errorCount.getValueAsLong(intervalName);
    }

    static {
        if (MoskitoWebUi.isPresent()) {
            DecoratorRegistryFactory.getDecoratorRegistry().addDecorator(GlobalRequestProcessorStats.class, (IDecorator)new GlobalRequestProcessorStatsDecorator());
        }
        VALUE_NAMES = Collections.unmodifiableList(Arrays.asList("RequestCount", "MaxTime", "BytesReceived", "BytesSent", "ProcessingTime", "ErrorCount"));
    }
}

