/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.predefined;

import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import net.anotheria.moskito.core.decorators.IDecoratorFactory;
import net.anotheria.moskito.core.decorators.mbean.MBeanDecoratorFactory;
import net.anotheria.moskito.core.producers.GenericStats;
import net.anotheria.moskito.core.producers.ICustomDecoratorStats;
import net.anotheria.moskito.core.stats.TypeAwareStatValue;

public class MBeanStats
extends GenericStats
implements ICustomDecoratorStats {
    private Map<String, String> statsValuesDescriptions = new HashMap<String, String>();

    public MBeanStats(String statsName, Map<MBeanAttributeInfo, TypeAwareStatValue> values) {
        super(statsName);
        for (Map.Entry<MBeanAttributeInfo, TypeAwareStatValue> valueEntry : values.entrySet()) {
            TypeAwareStatValue value = valueEntry.getValue();
            MBeanAttributeInfo mBeanAttributeInfo = valueEntry.getKey();
            this.putValue(value);
            this.statsValuesDescriptions.put(value.getName(), mBeanAttributeInfo.getDescription());
        }
    }

    public String getValueDescriptionByName(String valueName) {
        return this.statsValuesDescriptions.get(valueName);
    }

    @Override
    public String getDecoratorId() {
        return this.getName();
    }

    @Override
    public IDecoratorFactory getDecoratorFactory() {
        return new MBeanDecoratorFactory(this);
    }
}

