/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.predefined;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.producers.AbstractStats;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.moskito.core.stats.impl.StatValueFactory;

public class QueueStats
extends AbstractStats {
    public static final long MIN_SIZE_DEFAULT = Long.MAX_VALUE;
    public static final long MAX_SIZE_DEFAULT = 0L;
    private StatValue requests;
    private StatValue enqueued;
    private StatValue dequeued;
    private StatValue empty;
    private StatValue totalSize;
    private StatValue lastSize;
    private StatValue sumOfSizes;
    private StatValue maxSize;
    private StatValue minSize;
    private String name;

    public QueueStats() {
        this("unnamed", Constants.getDefaultIntervals());
    }

    public QueueStats(String name) {
        this(name, Constants.getDefaultIntervals());
    }

    public QueueStats(String aName, Interval[] selectedIntervals) {
        Long longPattern = 0L;
        this.name = aName;
        this.requests = StatValueFactory.createStatValue(longPattern, "requests", selectedIntervals);
        this.enqueued = StatValueFactory.createStatValue(longPattern, "enqueued", selectedIntervals);
        this.dequeued = StatValueFactory.createStatValue(longPattern, "dequeued", selectedIntervals);
        this.empty = StatValueFactory.createStatValue(longPattern, "empty", selectedIntervals);
        this.totalSize = StatValueFactory.createStatValue(longPattern, "totalSize", selectedIntervals);
        this.lastSize = StatValueFactory.createStatValue(longPattern, "lastSize", selectedIntervals);
        this.sumOfSizes = StatValueFactory.createStatValue(longPattern, "sumOfSizes", selectedIntervals);
        this.minSize = StatValueFactory.createStatValue(longPattern, "minSize", selectedIntervals);
        this.minSize.setDefaultValueAsLong(Long.MAX_VALUE);
        this.minSize.reset();
        this.maxSize = StatValueFactory.createStatValue(longPattern, "maxSize", selectedIntervals);
        this.maxSize.setDefaultValueAsLong(Long.MIN_VALUE);
        this.maxSize.reset();
        this.addStatValues(this.requests, this.enqueued, this.dequeued, this.empty, this.totalSize, this.lastSize, this.sumOfSizes, this.minSize, this.maxSize);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addRequest() {
        this.requests.increase();
    }

    public long getRequests(String intervalName) {
        return this.requests.getValueAsLong(intervalName);
    }

    public void addEnqueued() {
        this.enqueued.increase();
    }

    public long getEnqueued(String intervalName) {
        return this.enqueued.getValueAsLong(intervalName);
    }

    public long getDequeued(String intervalName) {
        return this.dequeued.getValueAsLong(intervalName);
    }

    public void addDequeued() {
        this.dequeued.increase();
    }

    public long getEmpty(String intervalName) {
        return this.empty.getValueAsLong(intervalName);
    }

    public void addEmpty() {
        this.empty.increase();
    }

    public long getFull(String intervalName) {
        return this.requests.getValueAsLong(intervalName) - this.enqueued.getValueAsLong(intervalName);
    }

    public long getTotalSize(String intervalName) {
        return this.totalSize.getValueAsLong(intervalName);
    }

    public void setTotalSize(long totalSize) {
        this.totalSize.setValueAsLong(totalSize);
    }

    public void setOnRequestLastSize(long size) {
        this.lastSize.setValueAsLong(size);
        this.sumOfSizes.increaseByLong(size);
        this.maxSize.setValueIfGreaterThanCurrentAsLong(size);
        this.minSize.setValueIfLesserThanCurrentAsLong(size);
    }

    public long getOnRequestLastSize(String intervalName) {
        return this.lastSize.getValueAsLong(intervalName);
    }

    public long getOnRequestMaxSize(String intervalName) {
        return this.maxSize.getValueAsLong(intervalName);
    }

    public long getOnRequestMinSize(String intervalName) {
        return this.minSize.getValueAsLong(intervalName);
    }

    public long getOnRequestAverageSize(String intervalName) {
        long sum = this.sumOfSizes.getValueAsLong(intervalName);
        if (sum == 0L) {
            return 0L;
        }
        return sum / this.requests.getValueAsLong(intervalName);
    }

    @Override
    public List<String> getAvailableValueNames() {
        return StatDef.getStatNames();
    }

    @Override
    public String toStatsString(String intervalName, TimeUnit timeUnit) {
        StringBuilder b = new StringBuilder();
        b.append(this.getName()).append(' ');
        b.append(StatDef.REQUESTS.getStatLabel()).append(this.getRequests(intervalName));
        b.append(StatDef.ENQUEUED.getStatLabel()).append(this.getEnqueued(intervalName));
        b.append(StatDef.FULL.getStatLabel()).append(this.getFull(intervalName));
        b.append(StatDef.EMPTY.getStatLabel()).append(this.getEmpty(intervalName));
        b.append(StatDef.DEQUEUED.getStatLabel()).append(this.getDequeued(intervalName));
        b.append(StatDef.TOTAL_SIZE.getStatLabel()).append(this.getTotalSize(intervalName));
        b.append(StatDef.ENQUEUE_LAST_SIZE.getStatLabel()).append(this.getOnRequestLastSize(intervalName));
        b.append(StatDef.ENQUEUE_MIN_SIZE.getStatLabel()).append(this.getOnRequestMinSize(intervalName));
        b.append(StatDef.ENQUEUE_MAX_SIZE.getStatLabel()).append(this.getOnRequestMaxSize(intervalName));
        b.append(StatDef.ENQUEUE_AVERAGE_SIZE.getStatLabel()).append(this.getOnRequestAverageSize(intervalName));
        return b.toString();
    }

    @Override
    public String getValueByNameAsString(String valueName, String intervalName, TimeUnit timeUnit) {
        if (valueName == null || valueName.isEmpty()) {
            throw new AssertionError((Object)"Value name can not be empty");
        }
        if (valueName.equalsIgnoreCase(StatDef.REQUESTS.getStatName())) {
            return String.valueOf(this.getRequests(intervalName));
        }
        if (valueName.equalsIgnoreCase(StatDef.ENQUEUED.getStatName())) {
            return String.valueOf(this.getEnqueued(intervalName));
        }
        if (valueName.equalsIgnoreCase(StatDef.DEQUEUED.getStatName())) {
            return String.valueOf(this.getDequeued(intervalName));
        }
        if (valueName.equalsIgnoreCase(StatDef.FULL.getStatName())) {
            return String.valueOf(this.getFull(intervalName));
        }
        if (valueName.equalsIgnoreCase(StatDef.EMPTY.getStatName())) {
            return String.valueOf(this.getEmpty(intervalName));
        }
        if (valueName.equalsIgnoreCase(StatDef.TOTAL_SIZE.getStatName())) {
            return String.valueOf(this.getTotalSize(intervalName));
        }
        if (valueName.equalsIgnoreCase(StatDef.ENQUEUE_LAST_SIZE.getStatName())) {
            return String.valueOf(this.getOnRequestLastSize(intervalName));
        }
        if (valueName.equalsIgnoreCase(StatDef.ENQUEUE_MIN_SIZE.getStatName())) {
            return String.valueOf(this.getOnRequestMinSize(intervalName));
        }
        if (valueName.equalsIgnoreCase(StatDef.ENQUEUE_MAX_SIZE.getStatName())) {
            return String.valueOf(this.getOnRequestMaxSize(intervalName));
        }
        if (valueName.equals(StatDef.ENQUEUE_AVERAGE_SIZE.getStatName())) {
            return String.valueOf(this.getOnRequestAverageSize(intervalName));
        }
        return super.getValueByNameAsString(valueName, intervalName, timeUnit);
    }

    public static enum StatDef {
        REQUESTS("Req"),
        ENQUEUED("Enq"),
        DEQUEUED("Deq"),
        FULL("Full"),
        EMPTY("Empty"),
        TOTAL_SIZE("TS"),
        ENQUEUE_LAST_SIZE("ELast"),
        ENQUEUE_MIN_SIZE("EMin"),
        ENQUEUE_MAX_SIZE("EMax"),
        ENQUEUE_AVERAGE_SIZE("EAvg");

        private String statName;

        private StatDef(String aStatName) {
            this.statName = aStatName;
        }

        public String getStatName() {
            return this.statName;
        }

        public String getStatLabel() {
            return ' ' + this.statName + ": ";
        }

        public static List<String> getStatNames() {
            ArrayList<String> ret = new ArrayList<String>(StatDef.values().length);
            for (StatDef v : StatDef.values()) {
                ret.add(v.getStatName());
            }
            return ret;
        }
    }
}

