/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.predefined;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import net.anotheria.moskito.core.calltrace.CurrentlyTracedCall;
import net.anotheria.moskito.core.calltrace.RunningTraceContainer;
import net.anotheria.moskito.core.calltrace.TraceStep;
import net.anotheria.moskito.core.calltrace.TracedCall;
import net.anotheria.moskito.core.dynamic.IOnDemandCallHandler;
import net.anotheria.moskito.core.predefined.ServiceStats;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;

public class ServiceStatsCallHandlerWithCallSysout
implements IOnDemandCallHandler {
    private AtomicLong callCounter = new AtomicLong(0L);
    private static AtomicLong instanceCounter = new AtomicLong(0L);
    private long instanceId = instanceCounter.incrementAndGet();
    private static AtomicLong overallCallCounter = new AtomicLong(0L);

    @Override
    public Object invoke(Object target, Object[] args, Method method, Class<?> targetClass, Class<?>[] declaredExceptions, IStats aDefaultStats, IStats aMethodStats, IStatsProducer producer) throws Throwable {
        CurrentlyTracedCall runningUseCase;
        String callId = overallCallCounter.incrementAndGet() + "-" + this.instanceId + '-' + this.callCounter.incrementAndGet();
        ServiceStats defaultStats = (ServiceStats)aDefaultStats;
        ServiceStats methodStats = (ServiceStats)aMethodStats;
        StringBuilder debugOutPreCall = new StringBuilder("--- MSK III ");
        try {
            debugOutPreCall.append(callId);
            debugOutPreCall.append(" --- Calling ");
            debugOutPreCall.append(targetClass.getSimpleName());
            debugOutPreCall.append('.');
            debugOutPreCall.append(method.getName());
            debugOutPreCall.append('(');
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    debugOutPreCall.append(args[i] == null ? "null" : args[i]);
                    if (i >= args.length - 1) continue;
                    debugOutPreCall.append(", ");
                }
            }
            debugOutPreCall.append(')');
        }
        catch (Exception e) {
            debugOutPreCall.append(" ERROR ").append(e.getMessage());
        }
        System.out.println(debugOutPreCall.toString());
        StringBuilder debugOutPostCall = new StringBuilder("--- MSK III ").append(callId).append(" --- Return ");
        defaultStats.addRequest();
        methodStats.addRequest();
        TracedCall aRunningUseCase = RunningTraceContainer.getCurrentlyTracedCall();
        TraceStep currentElement = null;
        CurrentlyTracedCall currentlyTracedCall = runningUseCase = aRunningUseCase.callTraced() ? (CurrentlyTracedCall)aRunningUseCase : null;
        if (runningUseCase != null) {
            currentElement = runningUseCase.startStep(producer.getProducerId() + '.' + method.getName(), producer, method.getName());
        }
        long startTime = System.nanoTime();
        try {
            Object ret = method.invoke(target, args);
            debugOutPostCall.append(ret);
            long exTime = System.nanoTime() - startTime;
            defaultStats.addExecutionTime(exTime);
            methodStats.addExecutionTime(exTime);
            Object object = ret;
            return object;
        }
        catch (InvocationTargetException e) {
            defaultStats.notifyError(e.getTargetException());
            methodStats.notifyError();
            if (currentElement != null) {
                currentElement.setAborted();
            }
            debugOutPostCall.append("ERR (E) ").append(e.getCause().getMessage()).append(' ').append(e.getCause().toString());
            throw e.getCause();
        }
        catch (Throwable t) {
            defaultStats.notifyError(t);
            methodStats.notifyError();
            if (currentElement != null) {
                currentElement.setAborted();
            }
            debugOutPostCall.append("ERR (T) ").append(t.getMessage()).append(' ').append(t.toString());
            throw t;
        }
        finally {
            defaultStats.notifyRequestFinished();
            methodStats.notifyRequestFinished();
            System.out.println(debugOutPostCall.toString());
            if (currentElement != null) {
                currentElement.setDuration(System.currentTimeMillis() - startTime);
            }
            if (runningUseCase != null) {
                runningUseCase.endStep();
            }
        }
    }
}

