/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.registry;

import java.util.List;
import net.anotheria.moskito.core.config.MoskitoConfigurationHolder;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.IProducerRegistryListener;
import net.anotheria.moskito.core.util.BuiltInProducer;
import net.anotheria.moskito.core.util.MBeanUtil;
import net.anotheria.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXBridgeListener<S extends IStats>
implements IProducerRegistryListener<S> {
    private static Logger log = LoggerFactory.getLogger(JMXBridgeListener.class);
    private static final char[] CHARS_TO_REMOVE_FROM_NAME = new char[]{' ', '\t', '\r', '\n', '(', ')', '+', '-'};

    @Override
    public void notifyProducerRegistered(IStatsProducer<S> producer) {
        if (producer instanceof BuiltInProducer) {
            return;
        }
        List<S> stats = producer.getStats();
        if (stats == null) {
            return;
        }
        for (IStats s : stats) {
            try {
                MBeanUtil.getInstance().registerMBean(s, this.createName(producer.getProducerId(), s.getName()));
            }
            catch (Exception e) {
                log.warn("can't register " + s.getName() + " in " + producer.getProducerId() + ", ignored.", (Throwable)e);
            }
        }
    }

    @Override
    public void notifyProducerUnregistered(IStatsProducer<S> producer) {
        List<S> stats = producer.getStats();
        if (stats == null) {
            return;
        }
        for (IStats s : stats) {
            try {
                boolean isUnregistered = MBeanUtil.getInstance().unregisterMBean(this.createName(producer.getProducerId(), s.getName()));
                if (isUnregistered) continue;
                log.debug("can't unregister " + s.getName() + " in " + producer.getProducerId() + ", MBean with such name is not registered");
            }
            catch (Exception e) {
                log.warn("can't unregister " + s.getName() + " in " + producer.getProducerId() + ", ignored.", (Throwable)e);
            }
        }
    }

    private String createName(String producerId, String statName) {
        String appName = this.encodeAppName(MoskitoConfigurationHolder.getConfiguration().getApplicationName());
        return "MoSKito." + (appName.length() > 0 ? appName + '.' : "") + "producers:type=" + producerId + '.' + statName;
    }

    private String encodeAppName(String appName) {
        return StringUtils.removeChars((String)appName, (char[])CHARS_TO_REMOVE_FROM_NAME);
    }
}

