/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.stats.impl;

import java.util.concurrent.atomic.AtomicInteger;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.impl.AbstractValueHolder;

class IntValueHolder
extends AbstractValueHolder {
    public static final int DEFAULT_DEFAULT_VALUE = 0;
    private AtomicInteger currentValue = new AtomicInteger(this.defaultValue);
    private int lastValue;
    private int defaultValue = 0;

    public IntValueHolder(Interval aInterval) {
        super(aInterval);
    }

    @Override
    public void intervalUpdated(Interval aCaller) {
        this.lastValue = this.currentValue.getAndSet(this.defaultValue);
    }

    public int getLastValue() {
        return this.lastValue;
    }

    @Override
    public String toString() {
        return super.toString() + " I " + this.lastValue + " / " + this.currentValue.get();
    }

    @Override
    public void decrease() {
        this.currentValue.decrementAndGet();
    }

    @Override
    public void increase() {
        this.currentValue.incrementAndGet();
    }

    @Override
    public void decreaseByDouble(double aValue) {
        this.decreaseByInt((int)aValue);
    }

    @Override
    public void decreaseByInt(int aValue) {
        this.currentValue.addAndGet(-aValue);
    }

    @Override
    public void decreaseByLong(long aValue) {
        this.decreaseByInt((int)aValue);
    }

    @Override
    public double getValueAsDouble() {
        return this.getValueAsInt();
    }

    @Override
    public int getValueAsInt() {
        return this.lastValue;
    }

    @Override
    public long getValueAsLong() {
        return this.getValueAsInt();
    }

    @Override
    public void increaseByDouble(double aValue) {
        this.increaseByInt((int)aValue);
    }

    @Override
    public void increaseByInt(int aValue) {
        this.currentValue.addAndGet(aValue);
    }

    @Override
    public void increaseByLong(long aValue) {
        this.increaseByInt((int)aValue);
    }

    @Override
    public void setValueAsDouble(double aValue) {
        this.setValueAsInt((int)aValue);
    }

    @Override
    public void setValueAsInt(int aValue) {
        this.currentValue.set(aValue);
    }

    @Override
    public void setValueAsLong(long aValue) {
        this.setValueAsInt((int)aValue);
    }

    @Override
    public void setDefaultValueAsLong(long aValue) {
        this.setDefaultValueAsInt((int)aValue);
    }

    @Override
    public void setDefaultValueAsInt(int aValue) {
        this.defaultValue = aValue;
    }

    @Override
    public void setDefaultValueAsDouble(double aValue) {
        this.setDefaultValueAsInt((int)aValue);
    }

    @Override
    public void reset() {
        this.currentValue.set(this.defaultValue);
        this.lastValue = this.defaultValue;
    }

    @Override
    public double getCurrentValueAsDouble() {
        return this.getCurrentValueAsLong();
    }

    @Override
    public int getCurrentValueAsInt() {
        return this.currentValue.get();
    }

    @Override
    public long getCurrentValueAsLong() {
        return this.getCurrentValueAsInt();
    }

    @Override
    public void setValueAsString(String aValue) {
        this.currentValue.set(Integer.parseInt(aValue));
    }

    @Override
    public String getValueAsString() {
        return String.valueOf(this.lastValue);
    }

    @Override
    public String getCurrentValueAsString() {
        return String.valueOf(this.currentValue.get());
    }
}

