/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.stats.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import net.anotheria.moskito.core.stats.IIntervalListener;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.IntervalRegistryListener;
import net.anotheria.moskito.core.stats.UnknownIntervalException;
import net.anotheria.moskito.core.stats.impl.IntervalImpl;
import net.anotheria.moskito.core.stats.impl.IntervalNameParser;
import net.anotheria.moskito.core.timing.IUpdateTriggerService;
import net.anotheria.moskito.core.timing.UpdateTriggerServiceFactory;

public final class IntervalRegistry {
    private static final IntervalRegistry instance = new IntervalRegistry();
    private Map<Integer, Interval> intervalsById = new ConcurrentHashMap<Integer, Interval>();
    private Map<String, Interval> intervalsByName = new ConcurrentHashMap<String, Interval>();
    private Map<String, Long> intervalUpdateTimestamp = new ConcurrentHashMap<String, Long>();
    private AtomicInteger nextId = new AtomicInteger(1);
    private IUpdateTriggerService updateTriggerService;
    private List<IntervalRegistryListener> registryListeners = new CopyOnWriteArrayList<IntervalRegistryListener>();

    private IntervalRegistry() {
        this.updateTriggerService = UpdateTriggerServiceFactory.getUpdateTriggerService();
    }

    public static IntervalRegistry getInstance() {
        return instance;
    }

    Interval getInterval(int aId) {
        Interval interval = this.intervalsById.get(aId);
        if (interval == null) {
            throw new UnknownIntervalException(aId);
        }
        return interval;
    }

    public Interval getInterval(String aName, int aLength) {
        Interval interval = this.intervalsByName.get(aName);
        if (interval == null) {
            interval = this.createInterval(aName, aLength);
        }
        return interval;
    }

    public Interval getInterval(String aName) {
        Interval interval = this.intervalsByName.get(aName);
        if (interval == null) {
            interval = this.createInterval(aName, IntervalNameParser.guessLengthFromName(aName));
        }
        return interval;
    }

    public Interval getIntervalOnlyIfExisting(String aName) {
        Interval interval = this.intervalsByName.get(aName);
        if (interval == null) {
            throw new UnknownIntervalException(aName);
        }
        return interval;
    }

    private Interval createInterval(String aName, int aLength) {
        IntervalImpl interval = new IntervalImpl(this.obtainNextUniqueId(), aName, aLength);
        if (aLength != -1) {
            this.updateTriggerService.addUpdateable(interval, aLength);
        }
        this.intervalsById.put(interval.getId(), interval);
        this.intervalsByName.put(interval.getName(), interval);
        for (IntervalRegistryListener listener : this.registryListeners) {
            listener.intervalCreated(interval);
        }
        interval.addSecondaryIntervalListener(new IIntervalListener(){

            @Override
            public void intervalUpdated(Interval aCaller) {
                IntervalRegistry.this.intervalUpdateTimestamp.put(aCaller.getName(), System.currentTimeMillis());
            }
        });
        return interval;
    }

    private int obtainNextUniqueId() {
        return this.nextId.getAndIncrement();
    }

    public List<Interval> getIntervals() {
        return new ArrayList<Interval>(this.intervalsByName.values());
    }

    public Long getUpdateTimestamp(String intervalName) {
        return intervalName == null ? Long.valueOf(0L) : this.intervalUpdateTimestamp.get(intervalName);
    }

    public void forceUpdateIntervalForTestingPurposes(String intervalName) {
        ((IntervalImpl)this.getInterval(intervalName)).update();
    }

    public void addIntervalRegistryListener(IntervalRegistryListener listener) {
        this.registryListeners.add(listener);
    }
}

