/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.tag;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.anotheria.moskito.core.config.MoskitoConfigurationHolder;
import net.anotheria.moskito.core.tag.TagType;

public class Tag
implements Comparable<Tag> {
    private static final String NULL = "null";
    private final String name;
    private final TagType type;
    private final String source;
    private final Map<String, Integer> values;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public Tag(String name, TagType type, String source) {
        this.name = name;
        this.type = type;
        this.source = source;
        this.values = new LinkedHashMap<String, Integer>();
    }

    public String getName() {
        return this.name;
    }

    public TagType getType() {
        return this.type;
    }

    public String getSource() {
        return this.source;
    }

    public Map<String, Integer> getLastValues() {
        return new LinkedHashMap<String, Integer>(this.values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValue(String value) {
        int tagHistorySize = MoskitoConfigurationHolder.getConfiguration().getTaggingConfig().getTagHistorySize();
        this.lock.writeLock().lock();
        try {
            String lastValue = value != null ? value : NULL;
            Integer amount = this.values.get(lastValue);
            if (amount != null) {
                amount = amount + 1;
                this.values.put(lastValue, amount);
                return;
            }
            if (this.values.size() >= tagHistorySize) {
                this.values.remove(this.values.keySet().iterator().next());
            }
            this.values.put(lastValue, 1);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public int compareTo(Tag o) {
        if (this.getType().equals((Object)o.getType())) {
            return this.getName().compareTo(o.getName());
        }
        return this.getType().compareTo(o.getType());
    }
}

