/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.tag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.anotheria.moskito.core.tag.Tag;
import net.anotheria.moskito.core.tag.TagType;

public enum TagRepository {
    INSTANCE;

    private final Map<String, Tag> tagsMap = new ConcurrentHashMap<String, Tag>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public void addTag(String name, String value, TagType type, String source) {
        Tag tag = this.getTag(name, type, source);
        tag.addValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tag getTag(String name, TagType type, String source) {
        this.lock.writeLock().lock();
        try {
            Tag tag = this.tagsMap.get(name);
            if (tag == null) {
                tag = new Tag(name, type, source);
                this.tagsMap.put(name, tag);
            }
            Tag tag2 = tag;
            return tag2;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public List<Tag> getTags() {
        ArrayList<Tag> tags = new ArrayList<Tag>(this.tagsMap.values());
        Collections.sort(tags);
        return tags;
    }
}

