/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.threshold;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.List;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import net.anotheria.moskito.core.config.MoskitoConfiguration;
import net.anotheria.moskito.core.config.MoskitoConfigurationHolder;
import net.anotheria.moskito.core.config.thresholds.GuardConfig;
import net.anotheria.moskito.core.config.thresholds.ThresholdConfig;
import net.anotheria.moskito.core.config.thresholds.ThresholdsConfig;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducer;
import net.anotheria.moskito.core.helper.TieableDefinition;
import net.anotheria.moskito.core.helper.TieableRepository;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.stats.TimeUnit;
import net.anotheria.moskito.core.threshold.CustomThresholdProvider;
import net.anotheria.moskito.core.threshold.ExtendedThresholdStatus;
import net.anotheria.moskito.core.threshold.Threshold;
import net.anotheria.moskito.core.threshold.ThresholdDefinition;
import net.anotheria.moskito.core.threshold.ThresholdInStatus;
import net.anotheria.moskito.core.threshold.ThresholdStatus;
import net.anotheria.moskito.core.threshold.guard.DoubleBarrierPassGuard;
import net.anotheria.moskito.core.threshold.guard.GuardedDirection;
import net.anotheria.moskito.core.threshold.guard.LongBarrierPassGuard;
import net.anotheria.moskito.core.util.MBeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThresholdRepository<S extends IStats>
extends TieableRepository<Threshold, S> {
    private static Logger log = LoggerFactory.getLogger(ThresholdRepository.class);
    private static ThresholdRepository<? extends IStats> INSTANCE = new ThresholdRepository();
    private MoskitoConfiguration configuration;

    private ThresholdRepository() {
        this.readConfig();
    }

    public static ThresholdRepository<? extends IStats> getInstance() {
        return INSTANCE;
    }

    @Override
    protected boolean tie(Threshold threshold, IStatsProducer<? extends IStats> producer) {
        ThresholdDefinition definition = (ThresholdDefinition)threshold.getDefinition();
        IStats target = null;
        for (IStats iStats : producer.getStats()) {
            if (!iStats.getName().equals(definition.getStatName())) continue;
            target = iStats;
            break;
        }
        if (target == null) {
            if (producer instanceof OnDemandStatsProducer) {
                this.addToAutoTie(threshold, producer);
            } else {
                throw new IllegalArgumentException("StatObject not found " + definition.getStatName() + " in " + definition);
            }
        }
        threshold.tieToStats(target);
        return true;
    }

    @Override
    public void cleanup() {
        List<Threshold> th = this.getThresholds();
        for (Threshold t : th) {
            String tName = ((ThresholdDefinition)t.getDefinition()).getName();
            try {
                MBeanUtil.getInstance().unregisterMBean(this.createName(tName));
            }
            catch (MBeanRegistrationException e) {
                log.warn("can't unregister " + tName + ", ignored.", (Throwable)e);
            }
        }
        super.cleanup();
    }

    private String createName(String name) {
        String appName = MoskitoConfigurationHolder.getConfiguration().getApplicationName();
        return "moskito." + (appName.length() > 0 ? appName + '.' : "") + "thresholds:type=" + name;
    }

    public Threshold createThreshold(ThresholdDefinition definition) {
        Threshold ret = (Threshold)this.createTieable(definition);
        try {
            String name = this.createName(((ThresholdDefinition)ret.getDefinition()).getName());
            MBeanUtil.getInstance().registerMBean(ret, name, true);
        }
        catch (MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            log.warn("can't subscribe threshold to jmx", (Throwable)e);
        }
        catch (AccessControlException e) {
            log.warn("can't create jmx bean due to access control problems", (Throwable)e);
        }
        return ret;
    }

    public Threshold createCustomThreshold(String name, CustomThresholdProvider provider, OnDemandStatsProducer<S> producer) {
        if (name == null) {
            throw new IllegalArgumentException("CustomThreshold name can not be null");
        }
        ThresholdDefinition definition = new ThresholdDefinition();
        definition.setName(name);
        definition.setIntervalName("1m");
        definition.setCustom(true);
        definition.setProducerName(producer.getProducerId());
        Threshold threshold = new Threshold(definition);
        threshold.tieToProvider(provider);
        this.addTieable(threshold);
        this.attachToListener(threshold);
        try {
            String mBeanName = this.createName(name);
            MBeanUtil.getInstance().registerMBean(threshold, mBeanName, true);
        }
        catch (MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            log.warn("can't subscribe threshold to jmx", (Throwable)e);
        }
        catch (AccessControlException e) {
            log.warn("can't create jmx bean due to access control problems", (Throwable)e);
        }
        return threshold;
    }

    public ExtendedThresholdStatus getExtendedWorstStatus(List<String> includedNames) {
        ThresholdStatus status = includedNames == null || includedNames.size() == 0 ? this.getWorstStatus() : this.getWorstStatus(includedNames);
        ExtendedThresholdStatus ret = new ExtendedThresholdStatus(status);
        for (Threshold t : this.getThresholds()) {
            if (t.getStatus() != status || includedNames != null && includedNames.indexOf(t.getName()) == -1) continue;
            ThresholdInStatus tis = new ThresholdInStatus();
            tis.setThresholdName(t.getName());
            tis.setValue(t.getLastValue());
            ret.add(tis);
        }
        return ret;
    }

    public ExtendedThresholdStatus getExtendedWorstStatusWithout(List<String> excludedNames) {
        ThresholdStatus status = this.getWorstStatusWithout(excludedNames);
        ExtendedThresholdStatus ret = new ExtendedThresholdStatus(status);
        for (Threshold t : this.getThresholds()) {
            if (t.getStatus() != status || excludedNames != null && excludedNames.indexOf(t.getName()) != -1) continue;
            ThresholdInStatus tis = new ThresholdInStatus();
            tis.setThresholdName(t.getName());
            tis.setValue(t.getLastValue());
            ret.add(tis);
        }
        return ret;
    }

    public ThresholdStatus getWorstStatus() {
        if (this.configuration.getKillSwitch().disableMetricCollection()) {
            return ThresholdStatus.OFF;
        }
        ThresholdStatus ret = ThresholdStatus.GREEN;
        for (Threshold t : this.getThresholds()) {
            if (t.getStatus() == null) {
                log.error("Threshold " + t + " has status NULL!");
                continue;
            }
            if (!t.getStatus().overrules(ret)) continue;
            ret = t.getStatus();
        }
        return ret;
    }

    public ThresholdStatus getWorstStatus(String[] names) {
        return this.getWorstStatus(Arrays.asList(names));
    }

    public ThresholdStatus getWorstStatus(List<String> names) {
        if (this.configuration.getKillSwitch().disableMetricCollection()) {
            return ThresholdStatus.OFF;
        }
        ThresholdStatus ret = ThresholdStatus.GREEN;
        for (Threshold t : this.getThresholds()) {
            if (names.indexOf(t.getName()) == -1 || !t.getStatus().overrules(ret)) continue;
            ret = t.getStatus();
        }
        return ret;
    }

    public ThresholdStatus getWorstStatusWithout(List<String> names) {
        if (this.configuration.getKillSwitch().disableMetricCollection()) {
            return ThresholdStatus.OFF;
        }
        ThresholdStatus ret = ThresholdStatus.GREEN;
        for (Threshold t : this.getThresholds()) {
            if (names.indexOf(t.getName()) != -1 || !t.getStatus().overrules(ret)) continue;
            ret = t.getStatus();
        }
        return ret;
    }

    public List<Threshold> getThresholds() {
        return this.getTieables();
    }

    @Override
    protected Threshold create(TieableDefinition def) {
        return new Threshold((ThresholdDefinition)def);
    }

    private void readConfig() {
        this.configuration = MoskitoConfigurationHolder.getConfiguration();
        ThresholdsConfig config = this.configuration.getThresholdsConfig();
        ThresholdConfig[] tcs = config.getThresholds();
        if (tcs != null && tcs.length > 0) {
            for (ThresholdConfig tc : tcs) {
                ThresholdDefinition td = new ThresholdDefinition();
                td.setName(tc.getName());
                td.setIntervalName(tc.getIntervalName());
                td.setProducerName(tc.getProducerName());
                td.setStatName(tc.getStatName());
                td.setTimeUnit(TimeUnit.valueOf(tc.getTimeUnit()));
                td.setValueName(tc.getValueName());
                Threshold newThreshold = this.createThreshold(td);
                GuardConfig[] guards = tc.getGuards();
                if (guards == null || guards.length <= 0) continue;
                boolean hasDots = false;
                for (GuardConfig guard : guards) {
                    hasDots |= this.hasDots(guard.getValue());
                }
                for (GuardConfig guard : guards) {
                    newThreshold.addGuard(hasDots ? new DoubleBarrierPassGuard(ThresholdStatus.valueOf(guard.getStatus()), Double.parseDouble(guard.getValue()), GuardedDirection.valueOf(guard.getDirection())) : new LongBarrierPassGuard(ThresholdStatus.valueOf(guard.getStatus()), Long.parseLong(guard.getValue()), GuardedDirection.valueOf(guard.getDirection())));
                }
            }
        }
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="This method is only for unit tests.")
    void reset() {
        this.cleanup();
        INSTANCE = new ThresholdRepository<S>();
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="This method is for unit testing only.")
    public static void resetForUnitTests() {
        ThresholdRepository.getInstance().reset();
    }

    private boolean hasDots(String ... params) {
        if (params == null) {
            return false;
        }
        for (String p : params) {
            if (p == null || p.indexOf(46) <= 0) continue;
            return true;
        }
        return false;
    }
}

