/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.threshold.alerts;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.anotheria.moskito.core.config.MoskitoConfiguration;
import net.anotheria.moskito.core.config.MoskitoConfigurationHolder;
import net.anotheria.moskito.core.config.thresholds.NotificationProviderConfig;
import net.anotheria.moskito.core.threshold.ThresholdStatus;
import net.anotheria.moskito.core.threshold.alerts.AlertHistory;
import net.anotheria.moskito.core.threshold.alerts.NotificationProvider;
import net.anotheria.moskito.core.threshold.alerts.ThresholdAlert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AlertDispatcher {
    INSTANCE;

    private transient List<NotificationProviderWrapper> providers;
    private transient ExecutorService changeExecutor;
    private final AtomicInteger threadCounter = new AtomicInteger(0);
    private static final Logger log;

    private AlertDispatcher() {
        this.reset();
    }

    void reset() {
        MoskitoConfiguration config = MoskitoConfigurationHolder.INSTANCE.getConfiguration();
        if (this.changeExecutor != null) {
            try {
                this.changeExecutor.shutdownNow();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.changeExecutor = Executors.newFixedThreadPool(config.getThresholdsAlertsConfig().getDispatcherThreadPoolSize(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "AlertDispatcherThread-" + AlertDispatcher.this.threadCounter.getAndIncrement());
                t.setDaemon(true);
                return t;
            }
        });
        this.providers = new CopyOnWriteArrayList<NotificationProviderWrapper>();
        for (NotificationProviderConfig providerDef : config.getThresholdsAlertsConfig().getNotificationProviders()) {
            try {
                NotificationProvider provider = (NotificationProvider)Class.forName(providerDef.getClassName()).newInstance();
                provider.configure(providerDef);
                this.providers.add(new NotificationProviderWrapper(provider, ThresholdStatus.valueOf(providerDef.getGuardedStatus())));
            }
            catch (Exception any) {
                if (providerDef == null) {
                    LoggerFactory.getLogger(AlertDispatcher.class).error("Couldn't instantiate notification provider due to nullity of a providerDef, check configuration.", (Throwable)any);
                    continue;
                }
                LoggerFactory.getLogger(AlertDispatcher.class).error("Couldn't instantiate notification provider of class " + providerDef.getClassName() + ", check configuration.", (Throwable)any);
            }
        }
    }

    public void dispatchAlert(final ThresholdAlert alert) {
        AlertHistory.INSTANCE.addAlert(alert);
        this.changeExecutor.execute(new Runnable(){

            @Override
            public void run() {
                for (NotificationProviderWrapper wrapper : AlertDispatcher.this.providers) {
                    try {
                        if (!alert.getNewStatus().overrulesOrEqual(wrapper.getStatus()) && !alert.getOldStatus().overrulesOrEqual(wrapper.getStatus())) continue;
                        wrapper.getProvider().onNewAlert(alert);
                    }
                    catch (Exception e) {
                        log.error("Couldn't deliver notification over notificationprovider " + wrapper.getProvider() + ", due", (Throwable)e);
                    }
                }
            }
        });
    }

    public static void shutdown() {
        AlertDispatcher.INSTANCE.changeExecutor.shutdown();
    }

    static {
        log = LoggerFactory.getLogger(AlertDispatcher.class);
    }

    private static class NotificationProviderWrapper {
        private ThresholdStatus status;
        private NotificationProvider provider;

        NotificationProviderWrapper(NotificationProvider aProvider, ThresholdStatus aStatus) {
            this.provider = aProvider;
            this.status = aStatus;
        }

        public ThresholdStatus getStatus() {
            return this.status;
        }

        public NotificationProvider getProvider() {
            return this.provider;
        }

        public String toString() {
            return (Object)((Object)this.status) + " " + this.provider;
        }
    }
}

