/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.tracer;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.anotheria.moskito.core.config.MoskitoConfigurationHolder;
import net.anotheria.moskito.core.config.tracing.TracingConfiguration;
import net.anotheria.moskito.core.journey.JourneyManager;
import net.anotheria.moskito.core.journey.JourneyManagerFactory;
import net.anotheria.moskito.core.tracer.Trace;
import net.anotheria.moskito.core.tracer.TraceSortType;
import net.anotheria.moskito.core.tracer.Tracers;
import net.anotheria.util.sorter.SortType;
import net.anotheria.util.sorter.StaticQuickSorter;

public class Tracer {
    private String producerId;
    private boolean enabled;
    private static JourneyManager journeyManager = JourneyManagerFactory.getJourneyManager();
    private TraceSortType sortTypeForKeepLongest = new TraceSortType(2, false);
    private ReadWriteLock resizeLock = new ReentrantReadWriteLock();
    private List<Trace> traces;
    private int totalEntryCount;

    public Tracer(String aProducerId) {
        this.producerId = aProducerId;
        this.enabled = true;
        this.traces = new CopyOnWriteArrayList<Trace>();
    }

    public String getProducerId() {
        return this.producerId;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getEntryCount() {
        return this.traces == null ? 0 : this.traces.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrace(Trace aTrace, int toleratedAmount, int maxAmount) {
        ++this.totalEntryCount;
        try {
            this.resizeLock.writeLock().lock();
            this.traces.add(aTrace);
            if (this.traces.size() <= toleratedAmount) {
                return;
            }
            TracingConfiguration config = MoskitoConfigurationHolder.getConfiguration().getTracingConfig();
            switch (config.getShrinkingStrategy()) {
                case KEEPLONGEST: {
                    List oldTraces = StaticQuickSorter.sort(this.traces, (SortType)this.sortTypeForKeepLongest);
                    this.traces = new CopyOnWriteArrayList<Trace>();
                    for (int i = 0; i < oldTraces.size(); ++i) {
                        if (i < maxAmount) {
                            this.traces.add((Trace)oldTraces.get(i));
                            continue;
                        }
                        journeyManager.getOrCreateJourney(Tracers.getJourneyNameForTracers(this.producerId)).removeStepByName(Tracers.getCallName((Trace)oldTraces.get(i)));
                    }
                    break;
                }
                case FIFO: {
                    List<Trace> oldTraces = this.traces;
                    this.traces = new CopyOnWriteArrayList<Trace>();
                    int offset = toleratedAmount - maxAmount;
                    for (int i = 0; i < oldTraces.size(); ++i) {
                        if (i >= 1 + offset && i <= maxAmount + offset) {
                            this.traces.add(oldTraces.get(i));
                            continue;
                        }
                        journeyManager.getOrCreateJourney(Tracers.getJourneyNameForTracers(this.producerId)).removeStepByName(Tracers.getCallName(oldTraces.get(i)));
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Shrinking strategy " + (Object)((Object)config.getShrinkingStrategy()) + " is not supported");
                }
            }
        }
        finally {
            this.resizeLock.writeLock().unlock();
        }
    }

    public List<Trace> getTraces() {
        try {
            this.resizeLock.readLock().lock();
            List<Trace> list = this.traces;
            return list;
        }
        finally {
            this.resizeLock.readLock().unlock();
        }
    }

    public int getTotalEntryCount() {
        return this.totalEntryCount;
    }

    public void setTotalEntryCount(int totalEntryCount) {
        this.totalEntryCount = totalEntryCount;
    }
}

