/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AfterStartTasks {
    private static ScheduledExecutorService scheduledExecutorService;
    private static Logger log;

    private AfterStartTasks() {
    }

    public static final void submitTask(Runnable r) {
        AfterStartTasks.submitTask(r, 10);
    }

    public static final void submitTask(Runnable r, int delayInSeconds) {
        log.debug("Scheduled " + r + " in " + delayInSeconds + " seconds.");
        scheduledExecutorService.schedule(r, (long)delayInSeconds, TimeUnit.SECONDS);
    }

    public static void shutdown() {
        scheduledExecutorService.shutdown();
    }

    static {
        log = LoggerFactory.getLogger(AfterStartTasks.class);
        scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    }
}

