/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.util;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import net.anotheria.moskito.core.accumulation.Accumulators;
import net.anotheria.moskito.core.predefined.GCStats;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.core.util.AbstractBuiltInProducer;
import net.anotheria.moskito.core.util.BuiltInProducer;
import net.anotheria.moskito.core.util.BuiltinUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuiltInGCProducer
extends AbstractBuiltInProducer
implements IStatsProducer,
BuiltInProducer {
    private List<IStats> iStatsList;
    private List<GarbageCollectorMXBean> mxBeans = ManagementFactory.getGarbageCollectorMXBeans();
    private static Logger log = LoggerFactory.getLogger(BuiltInGCProducer.class);

    public BuiltInGCProducer() {
        this.iStatsList = new ArrayList<IStats>(this.mxBeans.size());
        ArrayList<String> beanNames = new ArrayList<String>();
        for (GarbageCollectorMXBean bean : this.mxBeans) {
            this.iStatsList.add(new GCStats(bean.getName()));
            beanNames.add(bean.getName());
        }
        BuiltinUpdater.addTask(new TimerTask(){

            @Override
            public void run() {
                BuiltInGCProducer.this.readMbean();
            }
        });
        ProducerRegistryFactory.getProducerRegistryInstance().registerProducer(this);
        Accumulators.createGCAccumulators(beanNames);
    }

    @Override
    public String getCategory() {
        return "gc";
    }

    @Override
    public String getProducerId() {
        return "GC";
    }

    public List<IStats> getStats() {
        return this.iStatsList;
    }

    private void readMbean() {
        int i = 0;
        for (GarbageCollectorMXBean bean : this.mxBeans) {
            GCStats stat = (GCStats)this.iStatsList.get(i);
            stat.update(bean.getCollectionCount(), bean.getCollectionTime());
            ++i;
        }
    }
}

