/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import net.anotheria.moskito.core.accumulation.Accumulators;
import net.anotheria.moskito.core.predefined.OSStats;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.core.util.AbstractBuiltInProducer;
import net.anotheria.moskito.core.util.BuiltInProducer;
import net.anotheria.moskito.core.util.BuiltinUpdater;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuiltInOSProducer
extends AbstractBuiltInProducer
implements IStatsProducer,
BuiltInProducer {
    private OSStats stats;
    private List<IStats> statsList;
    private OperatingSystemMXBean mxBean;
    private static final String clazzname = "com.sun.management.UnixOperatingSystemMXBean";
    private Class<?> clazz;
    private static final int BITS_TO_BYTES_FACTOR = 1024;
    private final boolean isUnixOS = SystemUtils.IS_OS_UNIX;
    private final boolean isWindowsOS = SystemUtils.IS_OS_WINDOWS;
    private static Logger log = LoggerFactory.getLogger(BuiltInOSProducer.class);

    public BuiltInOSProducer() {
        this.mxBean = ManagementFactory.getOperatingSystemMXBean();
        this.statsList = new ArrayList<IStats>(1);
        this.stats = new OSStats();
        this.statsList.add(this.stats);
        try {
            this.clazz = Class.forName(clazzname);
        }
        catch (ClassNotFoundException e) {
            log.warn("Couldn't find unix version of os class: com.sun.management.UnixOperatingSystemMXBean, osstats won't operate properly - " + e.getMessage());
        }
        if (!this.isUnixOS) {
            log.warn("Couldn't find unix version of os class: com.sun.management.UnixOperatingSystemMXBean, osstats won't operate properly for all stats. Current type is: " + this.mxBean.getClass().getName());
        }
        BuiltinUpdater.addTask(new TimerTask(){

            @Override
            public void run() {
                BuiltInOSProducer.this.readMbean();
            }
        });
        ProducerRegistryFactory.getProducerRegistryInstance().registerProducer(this);
        Accumulators.setupCPUAccumulators();
    }

    @Override
    public String getCategory() {
        return "os";
    }

    @Override
    public String getProducerId() {
        return "OS";
    }

    public List<IStats> getStats() {
        return this.statsList;
    }

    private void readMbean() {
        if (this.clazz == null) {
            return;
        }
        try {
            if (this.isUnixOS) {
                long openFiles = this.getValue("OpenFileDescriptorCount");
                long maxOpenFiles = this.getValue("MaxFileDescriptorCount");
                long freePhysicalMemorySize = this.getValue("FreePhysicalMemorySize");
                long totalPhysicalMemorySize = this.getValue("TotalPhysicalMemorySize");
                long processTime = this.getValue("ProcessCpuTime");
                double processCPULoad = this.getDoubleValue("ProcessCpuLoad");
                double systemCPULoad = this.getDoubleValue("SystemCpuLoad");
                long processors = this.getValue("AvailableProcessors");
                this.stats.update((int)openFiles, (int)maxOpenFiles, freePhysicalMemorySize, totalPhysicalMemorySize, processTime, (int)processors, processCPULoad, systemCPULoad);
            } else if (this.isWindowsOS) {
                long processors = this.getValue("AvailableProcessors");
                double systemCPULoad = BuiltInOSProducer.readWindowsCPULoad();
                long totalPhysicalMemorySize = BuiltInOSProducer.readWindowsTotalMemory();
                long freePhysicalMemorySize = BuiltInOSProducer.readWindowsFreeMemory();
                this.stats.update(-1, -1, freePhysicalMemorySize, totalPhysicalMemorySize, -1L, (int)processors, -1.0, systemCPULoad);
            } else {
                long processors = this.getValue("AvailableProcessors");
                this.stats.update(-1, -1, -1L, -1L, -1L, (int)processors, -1.0, -1.0);
            }
        }
        catch (Exception e) {
            log.warn("Couldn't read value due to", (Throwable)e);
        }
    }

    private long getValue(String name) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method m = this.clazz.getMethod("get" + name, new Class[0]);
        if (name.equals("AvailableProcessors")) {
            return ((Integer)m.invoke((Object)this.mxBean, new Object[0])).intValue();
        }
        Long result = (Long)m.invoke((Object)this.mxBean, new Object[0]);
        return result;
    }

    private double getDoubleValue(String name) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method m = this.clazz.getMethod("get" + name, new Class[0]);
        Double result = (Double)m.invoke((Object)this.mxBean, new Object[0]);
        return result;
    }

    public static void main(String[] a) {
        new BuiltInOSProducer();
    }

    private static long readWindowsTotalMemory() {
        Long result = 0L;
        try {
            String[] command = "wmic OS get TotalVisibleMemorySize /Value".split(" ");
            String line = BuiltInOSProducer.executeMemoryInfoProcess(command);
            result = Long.parseLong(line.substring(line.indexOf("=") + 1)) * 1024L;
        }
        catch (Exception e) {
            log.error("unable to get TotalVisibleMemorySize from wmic", (Throwable)e);
        }
        return result;
    }

    private static long readWindowsFreeMemory() {
        Long result = 0L;
        try {
            String[] command = "wmic OS get FreePhysicalMemory /Value".split(" ");
            String line = BuiltInOSProducer.executeMemoryInfoProcess(command);
            result = Long.parseLong(line.substring(line.indexOf("=") + 1)) * 1024L;
        }
        catch (Exception e) {
            log.error("unable to get FreePhysicalMemory from wmic", (Throwable)e);
        }
        return result;
    }

    private static double readWindowsCPULoad() {
        Double result = 0.0;
        try {
            String[] command = "wmic cpu get LoadPercentage /Value".split(" ");
            String line = BuiltInOSProducer.executeMemoryInfoProcess(command);
            result = Double.parseDouble(line.substring(line.indexOf("=") + 1)) / 100.0;
        }
        catch (Exception e) {
            log.error("unable to get LoadPercentage from wmic", (Throwable)e);
        }
        return result;
    }

    private static String executeMemoryInfoProcess(String ... command) throws IOException {
        ProcessBuilder procBuilder = new ProcessBuilder(command);
        Process process = procBuilder.start();
        InputStream is = process.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        try (BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.trim().isEmpty()) continue;
                String string = line;
                return string;
            }
        }
        throw new IOException("Could not read memory process output for command " + command);
    }
}

