/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TimerTask;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import net.anotheria.moskito.core.accumulation.Accumulators;
import net.anotheria.moskito.core.config.MoskitoConfigurationHolder;
import net.anotheria.moskito.core.predefined.GlobalRequestProcessorStats;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.core.util.AbstractBuiltInProducer;
import net.anotheria.moskito.core.util.BuiltInProducer;
import net.anotheria.moskito.core.util.BuiltinUpdater;
import net.anotheria.moskito.core.util.MBeanProducerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuiltinGlobalRequestProcessorProducer
extends AbstractBuiltInProducer
implements IStatsProducer,
BuiltInProducer {
    private static final String MBEAN_NAME = "Catalina:name=\"%s\",type=GlobalRequestProcessor";
    private static final String[] ATTRIBUTE_NAMES = new String[]{"requestCount", "maxTime", "bytesReceived", "bytesSent", "processingTime", "errorCount"};
    private List<IStats> iStats;
    private List<ObjectInstance> mBeans;
    private MBeanServer mBeanServer;
    private static final Logger log = LoggerFactory.getLogger(BuiltinGlobalRequestProcessorProducer.class);

    public BuiltinGlobalRequestProcessorProducer() {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        boolean isAjp = MoskitoConfigurationHolder.getConfiguration().getTomcatRequestProcessorProducerConfig().isAjp();
        boolean isHttp = MoskitoConfigurationHolder.getConfiguration().getTomcatRequestProcessorProducerConfig().isHttp();
        String key = isAjp && isHttp ? "*" : (isHttp ? "http*" : "ajp*");
        try {
            for (MBeanServer server : servers) {
                Set<ObjectInstance> instances = server.queryMBeans(new ObjectName(String.format(MBEAN_NAME, key)), null);
                if (instances.size() == 0) continue;
                List<String> beanNames = this.initFieldsAndCreateStats(server, instances);
                this.addUpdaterTask();
                ProducerRegistryFactory.getProducerRegistryInstance().registerProducer(this);
                Accumulators.createGlobalRequestProcessorAccumulators(beanNames);
                break;
            }
        }
        catch (MalformedObjectNameException e) {
            log.error("Failed to get GlobalRequestProcessor mbeans", (Throwable)e);
        }
    }

    @Override
    public String getCategory() {
        return "tomcat";
    }

    @Override
    public String getProducerId() {
        return "GlobalRequestProcessor";
    }

    public List<IStats> getStats() {
        return this.iStats;
    }

    private List<String> initFieldsAndCreateStats(MBeanServer server, Set<ObjectInstance> instances) {
        this.iStats = new ArrayList<IStats>();
        this.mBeans = new ArrayList<ObjectInstance>();
        this.mBeanServer = server;
        ArrayList<String> beanNames = new ArrayList<String>();
        for (ObjectInstance instance : instances) {
            this.mBeans.add(instance);
            String beanName = MBeanProducerFactory.normalize(instance.getObjectName().getKeyProperty("name"));
            GlobalRequestProcessorStats stats = new GlobalRequestProcessorStats(beanName);
            this.iStats.add(stats);
            beanNames.add(beanName);
        }
        return beanNames;
    }

    private void addUpdaterTask() {
        BuiltinUpdater.addTask(new TimerTask(){

            @Override
            public void run() {
                BuiltinGlobalRequestProcessorProducer.this.readAttributes();
            }
        });
    }

    private void readAttributes() {
        try {
            int i = 0;
            for (ObjectInstance mbean : this.mBeans) {
                AttributeList attributeList = this.mBeanServer.getAttributes(mbean.getObjectName(), ATTRIBUTE_NAMES);
                if (attributeList.size() != ATTRIBUTE_NAMES.length) {
                    log.error("Failed to read GlobalRequestProcessor mbean attributes: " + attributeList.asList().toString());
                    return;
                }
                HashMap<String, Long> attributesMap = new HashMap<String, Long>();
                for (Attribute attribute : attributeList.asList()) {
                    attributesMap.put(attribute.getName(), Long.valueOf(attribute.getValue().toString()));
                }
                ((GlobalRequestProcessorStats)this.iStats.get(i)).update((Long)attributesMap.get(ATTRIBUTE_NAMES[0]), (Long)attributesMap.get(ATTRIBUTE_NAMES[1]), (Long)attributesMap.get(ATTRIBUTE_NAMES[2]), (Long)attributesMap.get(ATTRIBUTE_NAMES[3]), (Long)attributesMap.get(ATTRIBUTE_NAMES[4]), (Long)attributesMap.get(ATTRIBUTE_NAMES[5]));
                ++i;
            }
        }
        catch (InstanceNotFoundException | ReflectionException e) {
            log.error("Failed to read GlobalRequestProcessor mbean attributes ", (Throwable)e);
        }
    }
}

