/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.util;

import java.util.Collections;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import net.anotheria.moskito.core.config.MoskitoConfigurationHolder;
import net.anotheria.moskito.core.config.producers.MBeanProducerConfig;
import net.anotheria.moskito.core.decorators.DecoratorRegistryFactory;
import net.anotheria.moskito.core.decorators.IDecorator;
import net.anotheria.moskito.core.decorators.mbean.GeneralMBeanDecorator;
import net.anotheria.moskito.core.predefined.MBeanStats;
import net.anotheria.moskito.core.registry.IProducerRegistry;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.core.util.MBeanStatsFactory;
import net.anotheria.moskito.core.util.SimpleStatsProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanProducerFactory {
    private static final Logger log = LoggerFactory.getLogger(MBeanProducerFactory.class);
    private static final IProducerRegistry producerRegistry = ProducerRegistryFactory.getProducerRegistryInstance();
    private static final MBeanProducerConfig conf = MoskitoConfigurationHolder.getConfiguration().getMbeanProducersConfig();

    private static boolean isMBeanRequired(ObjectInstance mBean) {
        String domain = mBean.getObjectName().getDomain();
        String className = mBean.getClassName();
        return !domain.startsWith("moskito.") && conf.isMBeanRequired(domain, className);
    }

    public static String normalize(String s) {
        if (s == null || s.trim().isEmpty()) {
            return "unspecific";
        }
        return s.replace(':', '/').replace('=', '-').replace(',', '|').replace("\"", "").replace('#', '-');
    }

    public static void buildProducers() {
        DecoratorRegistryFactory.getDecoratorRegistry().addDecorator(MBeanStats.class, (IDecorator)new GeneralMBeanDecorator());
        for (MBeanServer server : MBeanServerFactory.findMBeanServer(null)) {
            for (ObjectInstance mBean : server.queryMBeans(null, null)) {
                SimpleStatsProducer<MBeanStats> producer;
                if (!MBeanProducerFactory.isMBeanRequired(mBean) || (producer = MBeanProducerFactory.buildProducer(server, mBean)) == null) continue;
                producerRegistry.registerProducer(producer);
                log.debug("Registered new producer for " + mBean.getObjectName().getCanonicalName() + "mbean");
            }
        }
    }

    private static SimpleStatsProducer<MBeanStats> buildProducer(MBeanServer server, ObjectInstance mBean) {
        ObjectName mBeanName = mBean.getObjectName();
        String canonicalName = mBeanName.getCanonicalName();
        String producerId = MBeanProducerFactory.normalize(canonicalName);
        String subsystem = MBeanProducerFactory.normalize(mBeanName.getDomain());
        try {
            MBeanStats stats = MBeanStatsFactory.createMBeanStats(server, mBeanName, conf.isUpdateAutomatically(), conf.getDelayBeforeFirstUpdate());
            if (stats != null) {
                return new SimpleStatsProducer<MBeanStats>(producerId, "mbean", subsystem, Collections.singletonList(stats));
            }
            log.info("Failed to create stats object from mbean named " + mBean + " because no one attribute can not be parsed from that been");
            return null;
        }
        catch (JMException e) {
            log.warn("Failed to create stats object from mbean named " + mBean, (Throwable)e);
            return null;
        }
    }
}

