/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.util;

import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.predefined.MBeanStats;
import net.anotheria.moskito.core.stats.StatValueTypes;
import net.anotheria.moskito.core.stats.TypeAwareStatValue;
import net.anotheria.moskito.core.stats.impl.StatValueFactory;
import net.anotheria.moskito.core.util.BuiltinUpdater;
import net.anotheria.moskito.core.util.MBeanProducerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanStatsFactory {
    private static final Logger log = LoggerFactory.getLogger(MBeanStatsFactory.class);

    private static StatValueTypes getStatValueType(MBeanAttributeInfo attributeInfo) {
        String attributeType = attributeInfo.getType();
        if (attributeType == null) {
            return null;
        }
        switch (attributeInfo.getType()) {
            case "long": 
            case "java.lang.Long": {
                return StatValueTypes.LONG;
            }
            case "int": 
            case "java.lang.Integer": {
                return StatValueTypes.INT;
            }
            case "double": 
            case "java.lang.Double": {
                return StatValueTypes.DOUBLE;
            }
            case "String": 
            case "java.lang.String": 
            case "boolean": 
            case "java.lang.Boolean": {
                return StatValueTypes.STRING;
            }
        }
        return null;
    }

    private static boolean updateValue(TypeAwareStatValue value, MBeanServer server, MBeanAttributeInfo attributeInfo, ObjectName mbeanName) {
        String attributeName = attributeInfo.getName();
        try {
            Object mBeanValue = server.getAttribute(mbeanName, attributeName);
            switch (value.getType()) {
                case LONG: {
                    value.setValueAsLong((Long)mBeanValue);
                    break;
                }
                case INT: {
                    value.setValueAsInt((Integer)mBeanValue);
                    break;
                }
                case DOUBLE: {
                    value.setValueAsDouble((Double)mBeanValue);
                    break;
                }
                case STRING: {
                    value.setValueAsString(mBeanValue == null ? "null" : mBeanValue.toString());
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        catch (ClassCastException | NullPointerException | JMException | JMRuntimeException e) {
            log.debug("Failed to update mbean stats value named " + attributeName + " of " + mbeanName.getCanonicalName() + " mbean", (Throwable)e);
            return false;
        }
    }

    private static TypeAwareStatValue buildValue(MBeanAttributeInfo attributeInfo) {
        StatValueTypes statType = MBeanStatsFactory.getStatValueType(attributeInfo);
        if (statType == null) {
            return null;
        }
        return StatValueFactory.createStatValue(statType, attributeInfo.getName(), Constants.getDefaultIntervals());
    }

    public static MBeanStats createMBeanStats(final MBeanServer server, final ObjectName mbean, boolean enableAutoUpdate, long delay) throws JMException {
        MBeanAttributeInfo[] attributeInfos = server.getMBeanInfo(mbean).getAttributes();
        final ConcurrentHashMap<MBeanAttributeInfo, TypeAwareStatValue> readableValues = new ConcurrentHashMap<MBeanAttributeInfo, TypeAwareStatValue>();
        for (MBeanAttributeInfo attributeInfo : attributeInfos) {
            if (!attributeInfo.isReadable()) continue;
            TypeAwareStatValue statValue = MBeanStatsFactory.buildValue(attributeInfo);
            if (statValue != null && MBeanStatsFactory.updateValue(statValue, server, attributeInfo, mbean)) {
                readableValues.put(attributeInfo, statValue);
                continue;
            }
            log.info("Failed to build stats value from attribute named " + attributeInfo.getName() + " of " + mbean.getCanonicalName() + " mbean.");
        }
        if (!readableValues.isEmpty()) {
            if (enableAutoUpdate) {
                BuiltinUpdater.addTask(new TimerTask(){

                    @Override
                    public void run() {
                        for (Map.Entry valueEntry : readableValues.entrySet()) {
                            MBeanStatsFactory.updateValue((TypeAwareStatValue)valueEntry.getValue(), server, (MBeanAttributeInfo)valueEntry.getKey(), mbean);
                        }
                    }
                }, delay);
            }
            return new MBeanStats(MBeanProducerFactory.normalize(mbean.getCanonicalKeyPropertyListString()), readableValues);
        }
        return null;
    }
}

