/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.util;

import java.lang.management.ManagementFactory;
import java.util.LinkedList;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanUtil {
    private static Logger log = LoggerFactory.getLogger(MBeanUtil.class);
    private final MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
    private LinkedList<ObjectName> beansNames = new LinkedList();
    private static MBeanUtil instance = new MBeanUtil();

    private MBeanUtil() {
    }

    public static MBeanUtil getInstance() {
        return instance;
    }

    static String resolveDuplicateName(String name) {
        if (name.matches("^copy\\d+\\..*$")) {
            Character prefixChar;
            StringBuilder copyPrefix = new StringBuilder(name.substring(0, name.indexOf(46)));
            StringBuilder copyNumber = new StringBuilder();
            char[] cArray = copyPrefix.reverse().toString().toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n && Character.isDigit((prefixChar = Character.valueOf(cArray[i])).charValue()); ++i) {
                copyNumber.append(prefixChar);
            }
            return "copy" + String.valueOf(Integer.parseInt(copyNumber.reverse().toString()) + 1) + "." + name.substring(name.indexOf(46) + 1);
        }
        return "copy1." + name;
    }

    public String registerMBean(Object bean, String name) throws MalformedObjectNameException, NotCompliantMBeanException, MBeanRegistrationException {
        return this.registerMBean(bean, name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String registerMBean(Object bean, String name, boolean replace) throws MalformedObjectNameException, NotCompliantMBeanException, MBeanRegistrationException {
        MBeanServer mBeanServer = this.mBeanServer;
        synchronized (mBeanServer) {
            ObjectName newBeanName = null;
            try {
                newBeanName = new ObjectName(name);
                this.beansNames.add(newBeanName);
                this.mBeanServer.registerMBean(bean, newBeanName);
                return name;
            }
            catch (InstanceAlreadyExistsException e) {
                this.beansNames.remove(newBeanName);
                if (replace) {
                    this.unregisterMBean(name);
                    return this.registerMBean(bean, name, true);
                }
                return this.registerMBean(bean, MBeanUtil.resolveDuplicateName(name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterMBean(String name) throws MBeanRegistrationException {
        MBeanServer mBeanServer = this.mBeanServer;
        synchronized (mBeanServer) {
            ObjectName toRemoveName;
            try {
                toRemoveName = new ObjectName(name);
            }
            catch (MalformedObjectNameException e) {
                return false;
            }
            this.beansNames.remove(toRemoveName);
            try {
                this.mBeanServer.unregisterMBean(toRemoveName);
                return true;
            }
            catch (InstanceNotFoundException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        MBeanServer mBeanServer = this.mBeanServer;
        synchronized (mBeanServer) {
            for (ObjectName beanName : this.beansNames) {
                try {
                    this.mBeanServer.unregisterMBean(beanName);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                }
                catch (MBeanRegistrationException e) {
                    log.warn("Exception thrown while trying to clean up registered MBeans", (Throwable)e);
                }
            }
        }
    }
}

