/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.anotheria.moskito.core.config.MoskitoConfigurationHolder;
import net.anotheria.moskito.core.config.producers.BuiltinProducersConfig;
import net.anotheria.moskito.core.errorhandling.BuiltInErrorProducer;
import net.anotheria.moskito.core.registry.IProducerRegistry;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.core.util.BuiltInGCProducer;
import net.anotheria.moskito.core.util.BuiltInMemoryPoolProducer;
import net.anotheria.moskito.core.util.BuiltInMemoryPoolVirtualProducer;
import net.anotheria.moskito.core.util.BuiltInMemoryProducer;
import net.anotheria.moskito.core.util.BuiltInOSProducer;
import net.anotheria.moskito.core.util.BuiltInRuntimeProducer;
import net.anotheria.moskito.core.util.BuiltInThreadCountProducer;
import net.anotheria.moskito.core.util.BuiltInThreadStatesProducer;
import net.anotheria.moskito.core.util.BuiltinGlobalRequestProcessorProducer;
import net.anotheria.moskito.core.util.MBeanProducerFactory;

public class StartBuiltInProducers {
    private static volatile boolean initialized = false;

    public static synchronized void startbuiltin() {
        if (initialized) {
            return;
        }
        initialized = true;
        StartBuiltInProducers.startJavaMemoryProducers();
        StartBuiltInProducers.startJavaThreadingProducers();
        StartBuiltInProducers.startOsProducers();
        StartBuiltInProducers.startGcProducers();
        StartBuiltInProducers.startMBeanProducers();
        StartBuiltInProducers.startTomcatRequestProcessorProducers();
    }

    public static void restartbuiltin() {
        initialized = false;
        StartBuiltInProducers.startbuiltin();
    }

    private static void startJavaThreadingProducers() {
        if (!MoskitoConfigurationHolder.getConfiguration().getBuiltinProducersConfig().isJavaThreadingProducers()) {
            return;
        }
        new BuiltInThreadStatesProducer();
        new BuiltInThreadCountProducer();
    }

    private static void startOsProducers() {
        if (MoskitoConfigurationHolder.getConfiguration().getBuiltinProducersConfig().isOsProducer()) {
            new BuiltInOSProducer();
        }
        if (MoskitoConfigurationHolder.getConfiguration().getBuiltinProducersConfig().isRuntimeProducer()) {
            new BuiltInRuntimeProducer();
        }
    }

    private static void startGcProducers() {
        if (MoskitoConfigurationHolder.getConfiguration().getBuiltinProducersConfig().isGcProducer()) {
            new BuiltInGCProducer();
        }
    }

    private static void startTomcatRequestProcessorProducers() {
        if (MoskitoConfigurationHolder.getConfiguration().getTomcatRequestProcessorProducerConfig().isRegister()) {
            new BuiltinGlobalRequestProcessorProducer();
        }
    }

    private static void startJavaMemoryProducers() {
        BuiltinProducersConfig config = MoskitoConfigurationHolder.getConfiguration().getBuiltinProducersConfig();
        if (config.isErrorProducer()) {
            BuiltInErrorProducer.getInstance();
        }
        IProducerRegistry registry = ProducerRegistryFactory.getProducerRegistryInstance();
        if (config.isJavaMemoryProducers()) {
            registry.registerProducer(new BuiltInMemoryProducer("JavaRuntimeFree"));
            registry.registerProducer(new BuiltInMemoryProducer("JavaRuntimeMax"));
            registry.registerProducer(new BuiltInMemoryProducer("JavaRuntimeTotal"));
        }
        if (config.isJavaMemoryPoolProducers()) {
            EnumMap<MemoryType, ArrayList<BuiltInMemoryPoolProducer>> producers = new EnumMap<MemoryType, ArrayList<BuiltInMemoryPoolProducer>>(MemoryType.class);
            List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean memoryPoolMXBean : pools) {
                BuiltInMemoryPoolProducer p = new BuiltInMemoryPoolProducer(memoryPoolMXBean);
                registry.registerProducer(p);
                ArrayList<BuiltInMemoryPoolProducer> pp = (ArrayList<BuiltInMemoryPoolProducer>)producers.get((Object)memoryPoolMXBean.getType());
                if (pp == null) {
                    pp = new ArrayList<BuiltInMemoryPoolProducer>(pools.size());
                    producers.put(memoryPoolMXBean.getType(), pp);
                }
                pp.add(p);
            }
            for (Map.Entry entry : producers.entrySet()) {
                BuiltInMemoryPoolVirtualProducer vp = new BuiltInMemoryPoolVirtualProducer((MemoryType)((Object)entry.getKey()), (List)entry.getValue());
                registry.registerProducer(vp);
            }
        }
    }

    private static void startMBeanProducers() {
        if (MoskitoConfigurationHolder.getConfiguration().getMbeanProducersConfig().isRegisterAutomatically()) {
            MBeanProducerFactory.buildProducers();
        }
    }
}

