/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.core.util.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public final class AnnotationUtils {
    private AnnotationUtils() {
        throw new IllegalAccessError("Can't be instantiated");
    }

    public static <A extends Annotation> A findAnnotation(AnnotatedElement source, Class<A> targetAnnotationClass) {
        Objects.requireNonNull(source, "incoming 'source' is not valid");
        Objects.requireNonNull(targetAnnotationClass, "incoming 'targetAnnotationClass' is not valid");
        A result = source.getAnnotation(targetAnnotationClass);
        if (result != null) {
            return result;
        }
        return AnnotationUtils.findAnnotationInAnnotations(source, targetAnnotationClass);
    }

    private static <A extends Annotation> A findAnnotationInAnnotations(AnnotatedElement source, Class<A> targetAnnotationClass) {
        Annotation[] allAnnotations;
        for (Annotation annotation : allAnnotations = source.getAnnotations()) {
            A result = AnnotationUtils.findAnnotation(annotation, targetAnnotationClass);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static <A extends Annotation> A findAnnotation(Annotation source, Class<A> targetAnnotationClass) {
        Objects.requireNonNull(source, "incoming 'source' is not valid");
        Objects.requireNonNull(targetAnnotationClass, "incoming 'targetAnnotationClass' is not valid");
        return AnnotationUtils.findAnnotation(source, targetAnnotationClass, new HashSet<Class<? extends Annotation>>());
    }

    private static <A extends Annotation> A findAnnotation(Annotation sourceAnnotation, Class<A> targetAnnotationClass, Set<Class<? extends Annotation>> alreadyCheckedAnnotations) {
        Annotation[] allAnnotations;
        Class<? extends Annotation> currentAnnotationType = sourceAnnotation.annotationType();
        alreadyCheckedAnnotations.add(currentAnnotationType);
        A result = currentAnnotationType.getAnnotation(targetAnnotationClass);
        if (result != null) {
            return result;
        }
        for (Annotation annotation : allAnnotations = currentAnnotationType.getAnnotations()) {
            A found;
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (alreadyCheckedAnnotations.contains(annotationType) || (found = AnnotationUtils.findAnnotation(annotation, targetAnnotationClass, alreadyCheckedAnnotations)) == null) continue;
            return found;
        }
        return null;
    }

    public static <A extends Annotation> A findTypeAnnotation(Class<?> type, Class<A> targetAnnotationClass) {
        Objects.requireNonNull(type, "incoming 'type' is not valid");
        Objects.requireNonNull(targetAnnotationClass, "incoming 'targetAnnotationClass' is not valid");
        if (type.equals(Object.class)) {
            return null;
        }
        A annotation = AnnotationUtils.findAnnotation(type, targetAnnotationClass);
        if (annotation != null) {
            return annotation;
        }
        Class<?> superClass = type.getSuperclass();
        if (superClass != null) {
            return AnnotationUtils.findTypeAnnotation(superClass, targetAnnotationClass);
        }
        return null;
    }
}

