/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.extensions.notificationproviders;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import net.anotheria.moskito.core.config.thresholds.NotificationProviderConfig;
import net.anotheria.moskito.core.threshold.alerts.NotificationProvider;
import net.anotheria.moskito.core.threshold.alerts.ThresholdAlert;
import net.anotheria.moskito.extensions.notificationproviders.ThresholdAlertConverter;
import net.anotheria.moskito.extensions.notificationtemplate.ThresholdAlertTemplate;
import net.anotheria.util.IOUtils;
import net.anotheria.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkSMSNotificationProvider
implements NotificationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(BulkSMSNotificationProvider.class);
    private static final String ENCODING = "ISO-8859-1";
    private static final URL PROVIDER_URL;
    private String smsTemplate;
    public static final String SMS_QUERY_FORMAT = "username=%s&password=%s&message=%s&msisdn=%s&want_report=1";
    private String user;
    private String password;
    private String recipients;

    public void configure(NotificationProviderConfig config) {
        this.user = (String)config.getProperties().get("user");
        this.password = (String)config.getProperties().get("password");
        this.recipients = (String)config.getProperties().get("recipients");
        try {
            this.smsTemplate = net.anotheria.moskito.core.util.IOUtils.getInputStreamAsString((InputStream)ClassLoader.getSystemResourceAsStream((String)config.getProperties().get("templatePath")));
        }
        catch (Throwable e) {
            LOGGER.warn("configure(): couldn't read template file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNewAlert(ThresholdAlert alert) {
        String query = this.formatQuery(alert);
        OutputStreamWriter writer = null;
        try {
            URLConnection conn = PROVIDER_URL.openConnection();
            conn.setDoOutput(true);
            writer = new OutputStreamWriter(conn.getOutputStream());
            writer.write(query);
            writer.flush();
            String response = IOUtils.readInputStreamBufferedAsString((InputStream)conn.getInputStream(), (String)ENCODING);
            LOGGER.info("onNewAlert(): Request sent: [" + query + "]. Response received: [" + response + "].");
            IOUtils.closeIgnoringException((Closeable)writer);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeIgnoringException(writer);
        }
    }

    private String formatQuery(ThresholdAlert alert) {
        return String.format(SMS_QUERY_FORMAT, this.user, this.password, BulkSMSNotificationProvider.createMessage(alert, this.smsTemplate), this.recipients);
    }

    private static String createMessage(ThresholdAlert alert, String template) {
        String message;
        if (!StringUtils.isEmpty((String)template)) {
            ThresholdAlertTemplate thresholdAlertTemplate = new ThresholdAlertTemplate(alert);
            message = thresholdAlertTemplate.process(template);
        } else {
            message = ThresholdAlertConverter.toPlainText(alert);
        }
        return message;
    }

    static {
        try {
            PROVIDER_URL = new URL("http://bulksms.vsms.net:5567/eapi/submission/send_sms/2/2.0");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

