/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.extensions.notificationproviders;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.anotheria.communication.data.AbstractMessage;
import net.anotheria.communication.data.HtmlMailMessage;
import net.anotheria.communication.service.MessagingService;
import net.anotheria.moskito.core.config.thresholds.NotificationProviderConfig;
import net.anotheria.moskito.core.threshold.alerts.NotificationProvider;
import net.anotheria.moskito.core.threshold.alerts.ThresholdAlert;
import net.anotheria.moskito.core.util.IOUtils;
import net.anotheria.moskito.extensions.notificationproviders.NotificationProviderConfigKey;
import net.anotheria.moskito.extensions.notificationproviders.ThresholdAlertConverter;
import net.anotheria.moskito.extensions.notificationtemplate.ThresholdAlertTemplate;
import net.anotheria.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailNotificationProvider
implements NotificationProvider {
    private List<String> recipients = new ArrayList<String>();
    private MessagingService messagingService;
    private String htmlTemplateString;
    private String plainTextTemplateString;
    private static Logger log = LoggerFactory.getLogger(MailNotificationProvider.class);

    public void configure(NotificationProviderConfig config) {
        try {
            String[] tokens;
            this.messagingService = MessagingService.getInstance();
            for (String t : tokens = StringUtils.tokenize((String)((String)config.getProperties().get(NotificationProviderConfigKey.RECIPIENTS.getKey())), (char)',')) {
                if (t.length() <= 0) continue;
                this.recipients.add(t.trim());
            }
            try {
                String htmlTemplateStringName = (String)config.getProperties().get(NotificationProviderConfigKey.HTML_TEMPLATE_PATH.getKey());
                if (htmlTemplateStringName != null && htmlTemplateStringName.length() > 0) {
                    this.htmlTemplateString = this.getFileContent(htmlTemplateStringName);
                }
            }
            catch (IOException e) {
                log.warn("Can't get html template '" + (String)config.getProperties().get(NotificationProviderConfigKey.HTML_TEMPLATE_PATH.getKey()) + "' config ", (Throwable)e);
            }
            try {
                String plainTextTemplateStringName = (String)config.getProperties().get(NotificationProviderConfigKey.TEXT_TEMPLATE_PATH.getKey());
                if (plainTextTemplateStringName != null && plainTextTemplateStringName.length() > 0) {
                    this.plainTextTemplateString = this.getFileContent(plainTextTemplateStringName);
                }
            }
            catch (IOException e) {
                log.warn("Can't get text template '" + (String)config.getProperties().get(NotificationProviderConfigKey.TEXT_TEMPLATE_PATH.getKey()) + "' config ", (Throwable)e);
            }
        }
        catch (Exception t) {
            log.warn("couldn't parse recipients or templates from config  " + this.htmlTemplateString, (Object)config);
        }
    }

    private String getFileContent(String name) throws IOException {
        ClassLoader myLoader = this.getClass().getClassLoader();
        URL url = myLoader.getResource(name);
        return IOUtils.getInputStreamAsString((InputStream)myLoader.getResourceAsStream(name));
    }

    public void onNewAlert(ThresholdAlert alert) {
        HtmlMailMessage message = new HtmlMailMessage();
        message.setSender("moskito@anotheria.net");
        message.setSenderName("MoSKito Threshold Alert");
        message.setSubject("Threshold alert: " + alert);
        ThresholdAlertTemplate thresholdAlertTemplate = new ThresholdAlertTemplate(alert);
        if (!StringUtils.isEmpty((String)this.plainTextTemplateString)) {
            message.setPlainTextContent(thresholdAlertTemplate.process(this.plainTextTemplateString));
        } else {
            message.setPlainTextContent(ThresholdAlertConverter.toPlainText(alert));
        }
        if (!StringUtils.isEmpty((String)this.htmlTemplateString)) {
            message.setHtmlContent(thresholdAlertTemplate.process(this.htmlTemplateString));
        }
        for (String r : this.recipients) {
            message.setRecipient(r);
            try {
                boolean sent = this.messagingService.sendMessage((AbstractMessage)message);
                if (sent) continue;
                log.error("Can't send message to " + r);
            }
            catch (Exception e) {
                log.error("onNewAlert(" + alert + "), to:  " + r + ')', (Throwable)e);
            }
        }
    }
}

