/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.extensions.notificationproviders;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.InputStream;
import java.util.ArrayList;
import net.anotheria.moskito.core.config.thresholds.NotificationProviderConfig;
import net.anotheria.moskito.core.threshold.alerts.NotificationProvider;
import net.anotheria.moskito.core.threshold.alerts.ThresholdAlert;
import net.anotheria.moskito.core.util.IOUtils;
import net.anotheria.moskito.extensions.notificationproviders.NotificationProviderConfigKey;
import net.anotheria.moskito.extensions.notificationproviders.ThresholdAlertConverter;
import net.anotheria.moskito.extensions.notificationtemplate.ThresholdAlertTemplate;
import net.anotheria.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailgunNotificationProvider
implements NotificationProvider {
    public static final String SYSTEM_PROPERTY_API_KEY = MailgunNotificationProvider.class.getSimpleName() + "APIKey";
    public static final String SYSTEM_PROPERTY_SENDER = MailgunNotificationProvider.class.getSimpleName() + "Sender";
    private static final String DEFAULT_API_KEY = "key-72d3spjfr06x0knhupx4z1v0e2bgjfk3";
    private static final String DEFAULT_SENDER = "MoSKito Alerts <moskito-alert@moskito.org>";
    private ArrayList<String> recipients = null;
    private static Logger log = LoggerFactory.getLogger(MailgunNotificationProvider.class);
    private final String apiKey;
    private final String sender;
    private String htmlTemplate;
    private String plainTextTemplate;
    private Client client = Client.create();

    public MailgunNotificationProvider() {
        String anApiKey = System.getProperty(SYSTEM_PROPERTY_API_KEY);
        if (anApiKey == null) {
            log.info("Using default api key, set -D" + SYSTEM_PROPERTY_API_KEY + "=<api_key> if you want to use own key");
            anApiKey = DEFAULT_API_KEY;
        }
        this.apiKey = anApiKey;
        this.sender = System.getProperty(SYSTEM_PROPERTY_SENDER, DEFAULT_SENDER);
        log.debug("Sender is " + this.sender);
        this.client.addFilter((ClientFilter)new HTTPBasicAuthFilter("api", this.apiKey));
    }

    public void configure(NotificationProviderConfig config) {
        try {
            String[] tokens = StringUtils.tokenize((String)((String)config.getProperties().get(NotificationProviderConfigKey.RECIPIENTS.getKey())), (char)',');
            this.recipients = new ArrayList(tokens.length);
            for (String t : tokens) {
                if (t.length() <= 0) continue;
                this.recipients.add(t.trim());
            }
            this.htmlTemplate = IOUtils.getInputStreamAsString((InputStream)ClassLoader.getSystemResourceAsStream((String)config.getProperties().get(NotificationProviderConfigKey.HTML_TEMPLATE_PATH.getKey())));
            this.plainTextTemplate = IOUtils.getInputStreamAsString((InputStream)ClassLoader.getSystemResourceAsStream((String)config.getProperties().get(NotificationProviderConfigKey.TEXT_TEMPLATE_PATH.getKey())));
        }
        catch (Throwable e) {
            log.warn("couldn't initialize config  " + config, e);
        }
    }

    public void onNewAlert(ThresholdAlert alert) {
        block9: {
            String subject = "Threshold alert: " + alert;
            try {
                WebResource webResource = this.client.resource("https://api.mailgun.net/v2/moskito.org/messages");
                MultivaluedMapImpl formData = new MultivaluedMapImpl();
                formData.add("from", DEFAULT_SENDER);
                for (String r : this.recipients) {
                    formData.add("to", r);
                }
                formData.add("subject", subject);
                ThresholdAlertTemplate thresholdAlertTemplate = new ThresholdAlertTemplate(alert);
                if (!StringUtils.isEmpty((String)this.plainTextTemplate)) {
                    formData.add("text", thresholdAlertTemplate.process(this.plainTextTemplate));
                } else {
                    formData.add("text", ThresholdAlertConverter.toPlainText(alert));
                }
                if (!StringUtils.isEmpty((String)this.htmlTemplate)) {
                    formData.add("html", thresholdAlertTemplate.process(this.htmlTemplate));
                }
                try {
                    ClientResponse response = (ClientResponse)webResource.type("application/x-www-form-urlencoded").post(ClientResponse.class, (Object)formData);
                    if (response.getStatus() != 200) {
                        log.warn("Couldn't send email, status expected 200, got " + response.getStatus());
                        break block9;
                    }
                    byte[] data = new byte[response.getLength()];
                    log.debug("Successfully sent notification mail " + new String(data));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    log.error("Couldn't send email", e);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("Couldn't send email", (Throwable)e);
            }
        }
    }
}

