/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.extensions.notificationtemplate;

import java.io.Serializable;
import net.anotheria.moskito.core.threshold.alerts.ThresholdAlert;
import net.anotheria.moskito.extensions.notificationtemplate.AbstractMailTemplate;
import net.anotheria.moskito.extensions.notificationtemplate.MailTemplateReplacementContext;
import net.anotheria.util.NumberUtils;
import net.anotheria.util.content.template.TemplateReplacementContext;
import net.anotheria.util.content.template.TemplateUtility;

public class ThresholdAlertTemplate
extends AbstractMailTemplate {
    private static final long serialVersionUID = 1L;
    private static final String THRESHOLD = "threshold";
    private static final String TIMESTAMP = "timestamp";
    private static final String OLD_STATUS = "oldStatus";
    private static final String NEW_STATUS = "newStatus";
    private static final String NEW_VALUE = "newValue";
    private static final String OLD_VALUE = "oldValue";

    public ThresholdAlertTemplate(ThresholdAlert thresholdAlert) {
        if (thresholdAlert == null) {
            throw new IllegalArgumentException("thresholdAlert is null");
        }
        this.setParameter(THRESHOLD, (Serializable)((Object)thresholdAlert.getThreshold().getName()));
        this.setParameter(TIMESTAMP, (Serializable)((Object)NumberUtils.makeISO8601TimestampString((long)thresholdAlert.getTimestamp())));
        this.setParameter(OLD_STATUS, (Serializable)((Object)thresholdAlert.getOldStatus().name()));
        this.setParameter(NEW_STATUS, (Serializable)((Object)thresholdAlert.getNewStatus().name()));
        this.setParameter(NEW_VALUE, (Serializable)((Object)thresholdAlert.getNewValue()));
        this.setParameter(OLD_VALUE, (Serializable)((Object)thresholdAlert.getOldValue()));
    }

    @Override
    public String process(String src) {
        MailTemplateReplacementContext context = new MailTemplateReplacementContext(this);
        return TemplateUtility.replaceVariables((TemplateReplacementContext)context, (String)src);
    }
}

