/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.extensions.php;

import net.anotheria.extensions.php.ConfigBootstrapper;
import net.anotheria.extensions.php.exceptions.PHPPluginBootstrapException;
import net.anotheria.extensions.php.stats.PHPScriptExecutionStats;
import net.anotheria.extensions.php.stats.decorators.PhpScriptExecutionStatDecorator;
import net.anotheria.moskito.core.decorators.DecoratorRegistryFactory;
import net.anotheria.moskito.core.decorators.IDecorator;
import net.anotheria.moskito.core.plugins.AbstractMoskitoPlugin;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoskitoPHPPlugin
extends AbstractMoskitoPlugin {
    private static final Logger log = LoggerFactory.getLogger(MoskitoPHPPlugin.class);
    private ConfigBootstrapper configBootstrapper;
    private String configurationName;

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public void initialize() {
        if (this.configurationName == null) {
            throw new PHPPluginBootstrapException("Configuration name is not set for Moskito PHP plugin");
        }
        log.info("Initializing Moskito PHP plugin with configuration " + this.configurationName + "...");
        DecoratorRegistryFactory.getDecoratorRegistry().addDecorator(PHPScriptExecutionStats.class, (IDecorator)new PhpScriptExecutionStatDecorator());
        this.configBootstrapper = new ConfigBootstrapper(this.configurationName);
        this.configBootstrapper.bootstrapPlugin(ProducerRegistryFactory.getProducerRegistryInstance());
    }

    public void deInitialize() {
        log.info("Deinitializing Moskito PHP plugin...");
        this.configBootstrapper.destroyPlugin();
    }
}

