/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.extensions.php;

import net.anotheria.extensions.php.MappersRegistry;
import net.anotheria.extensions.php.OnProducerDataReceivedListener;
import net.anotheria.extensions.php.dto.PHPProducerDTO;
import net.anotheria.extensions.php.exceptions.MappingException;
import net.anotheria.extensions.php.mappers.Mapper;
import net.anotheria.moskito.core.registry.IProducerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OnProducerDataReceivedListenerImpl
implements OnProducerDataReceivedListener {
    private static final Logger log = LoggerFactory.getLogger(OnProducerDataReceivedListenerImpl.class);
    private final MappersRegistry mappersRegistry;
    private final IProducerRegistry producerRegistry;

    OnProducerDataReceivedListenerImpl(MappersRegistry mappersRegistry, IProducerRegistry producerRegistry) {
        this.mappersRegistry = mappersRegistry;
        this.producerRegistry = producerRegistry;
    }

    @Override
    public synchronized void updateProducer(PHPProducerDTO producerDTO) {
        Mapper mapper = this.mappersRegistry.getMapper(producerDTO.getMapperId());
        if (mapper == null) {
            log.error("Mapper with id " + producerDTO.getMapperId() + " is not found to map producer " + producerDTO.getProducerId());
            return;
        }
        try {
            mapper.mapProducer(this.producerRegistry, producerDTO);
        }
        catch (MappingException e) {
            log.error("Failed to process producer data with producer id " + producerDTO.getProducerId() + " because mapper throws an exception", (Throwable)e);
        }
    }
}

