/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.extensions.php.connectors.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import net.anotheria.extensions.php.connectors.AbstractConnector;
import net.anotheria.extensions.php.dto.PHPProducerDTO;
import net.anotheria.extensions.php.exceptions.ConnectorInitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQConnector
extends AbstractConnector {
    private static final Logger log = LoggerFactory.getLogger(RabbitMQConnector.class);
    private static final Gson gson = new GsonBuilder().create();
    private Connection connection;
    private Channel channel;
    private long enabledInTimestamp;

    @Override
    public Properties getDefaultProperties() {
        Properties properties = new Properties();
        properties.setProperty("connector.host", "localhost");
        properties.setProperty("connector.port", "5672");
        properties.setProperty("connector.username", "guest");
        properties.setProperty("connector.password", "guest");
        properties.setProperty("connector.queue-name", "moskito-php");
        return properties;
    }

    @Override
    public void initWithDefaultProperties(Properties properties) throws ConnectorInitException {
        log.debug("Starting to initWithDefaultProperties RabbitMQ connector in php plugin...");
        ConnectionFactory factory = new ConnectionFactory();
        factory.setHost(properties.getProperty("connector.host"));
        factory.setPort(Integer.parseInt(properties.getProperty("connector.port")));
        factory.setUsername(properties.getProperty("connector.username"));
        factory.setPassword(properties.getProperty("connector.password"));
        try {
            this.connection = factory.newConnection();
            this.channel = this.connection.createChannel();
            this.channel.queueDeclare(properties.getProperty("connector.queue-name"), false, false, false, null);
            this.channel.basicConsume(properties.getProperty("connector.queue-name"), true, (Consumer)new MoskitoPHPConsumer(this.channel));
            this.enabledInTimestamp = System.currentTimeMillis();
        }
        catch (IOException | TimeoutException e) {
            this.deinit();
            throw new ConnectorInitException("Failed to open connection to RabbitMQ", e);
        }
    }

    @Override
    public void deinit() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException | TimeoutException e) {
                log.warn("Failed to close channel in RabbitMQ connector");
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException e) {
                log.warn("Failed to close connection in RabbitMQ connector");
            }
        }
    }

    private class MoskitoPHPConsumer
    extends DefaultConsumer {
        private MoskitoPHPConsumer(Channel channel) {
            super(channel);
        }

        public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
            PHPProducerDTO producerDTO;
            try {
                producerDTO = (PHPProducerDTO)gson.fromJson(new String(body, "UTF-8"), PHPProducerDTO.class);
            }
            catch (JsonSyntaxException e) {
                log.error("Failed to parse incoming json data.", (Throwable)e);
                return;
            }
            if (producerDTO.getTimestamp() * 1000.0 > (double)RabbitMQConnector.this.enabledInTimestamp) {
                RabbitMQConnector.this.updateProducer(producerDTO);
            }
        }
    }
}

