/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.extensions.php.mappers;

import java.util.HashMap;
import java.util.Map;
import net.anotheria.extensions.php.exceptions.ValueNotFoundException;

public class StatsValues
extends HashMap<String, Object> {
    private Object parseValue(String value) {
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            if (value.equals("true") || value.equals("false")) {
                return Boolean.valueOf(value);
            }
            throw new IllegalArgumentException("Only number or boolean stats values allowed");
        }
    }

    public StatsValues(Map<? extends String, String> m) {
        for (Map.Entry<? extends String, String> entry : m.entrySet()) {
            this.put(entry.getKey(), this.parseValue(entry.getValue()));
        }
    }

    public long getAsLong(String key) throws ClassCastException, ValueNotFoundException {
        Object value = this.get(key);
        if (value == null) {
            throw new ValueNotFoundException("Value with key " + key + " is not found");
        }
        return ((Number)value).longValue();
    }

    public double getAsDouble(String key) throws ClassCastException, ValueNotFoundException {
        Object value = this.get(key);
        if (value == null) {
            throw new ValueNotFoundException("Value with key " + key + " is not found");
        }
        return ((Number)value).doubleValue();
    }

    public boolean getAsBoolean(String key) throws ClassCastException, ValueNotFoundException {
        Object value = this.get(key);
        if (value == null) {
            throw new ValueNotFoundException("Value with key " + key + " is not found");
        }
        return (Boolean)value;
    }

    public long getAsLongOrDefault(String key, long defaultValue) throws ClassCastException, ValueNotFoundException {
        Object value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return ((Number)value).longValue();
    }

    public double getAsDoubleOrDefault(String key, double defaultValue) throws ClassCastException, ValueNotFoundException {
        Object value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return ((Number)value).doubleValue();
    }

    public boolean getAsBooleanOrDefault(String key, boolean defaultValue) throws ClassCastException, ValueNotFoundException {
        Object value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (Boolean)value;
    }
}

