/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.extensions.php;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import net.anotheria.extensions.php.ConnectorsRegistry;
import net.anotheria.extensions.php.MappersRegistry;
import net.anotheria.extensions.php.OnProducerDataReceivedListener;
import net.anotheria.extensions.php.OnProducerDataReceivedListenerImpl;
import net.anotheria.extensions.php.config.ConfigChangedNotifier;
import net.anotheria.extensions.php.config.ConnectorConfig;
import net.anotheria.extensions.php.config.MapperConfig;
import net.anotheria.extensions.php.config.MoskitoPHPConfig;
import net.anotheria.extensions.php.connectors.Connector;
import net.anotheria.extensions.php.exceptions.ConnectorInitException;
import net.anotheria.extensions.php.exceptions.PHPPluginBootstrapException;
import net.anotheria.extensions.php.mappers.Mapper;
import net.anotheria.moskito.core.registry.IProducerRegistry;
import org.configureme.ConfigurationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigBootstrapper {
    private static final Logger log = LoggerFactory.getLogger(ConfigBootstrapper.class);
    private ConnectorsRegistry connectorsRegistry = new ConnectorsRegistry();
    private MoskitoPHPConfig config = new MoskitoPHPConfig();
    private OnProducerDataReceivedListener listener;
    private Properties startupProperties;
    private static final String PROPERTY_CONNECTORS_FORCE_ENABLED = "forceEnablePHPConnectors";
    private static final String PROPERTY_TRUE_VALUE = "true";

    ConfigBootstrapper(String configurationName) {
        ConfigurationManager.INSTANCE.configureAs((Object)this.config, configurationName);
        this.startupProperties = new Properties();
        this.startupProperties.put(PROPERTY_CONNECTORS_FORCE_ENABLED, System.getProperty(PROPERTY_CONNECTORS_FORCE_ENABLED, "false"));
    }

    private static Object createInstance(String className) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?> clazz = Class.forName(className);
        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
        return constructor.newInstance(new Object[0]);
    }

    private Connector createConnector(ConnectorConfig config, OnProducerDataReceivedListener listener) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException, ClassCastException {
        Connector connector = (Connector)ConfigBootstrapper.createInstance(config.getConnectorClass());
        connector.setOnProducerDataReceivedListener(listener);
        return connector;
    }

    void bootstrapPlugin(IProducerRegistry producerRegistry) throws PHPPluginBootstrapException {
        this.config.setConfigChangedNotifier(new ConfigChangedNotifierImpl());
        MappersRegistry mappersRegistry = new MappersRegistry();
        this.listener = new OnProducerDataReceivedListenerImpl(mappersRegistry, producerRegistry);
        for (MapperConfig mapperConfig : this.config.getMappers()) {
            try {
                mappersRegistry.registerMapper(mapperConfig.getMapperId(), (Mapper)ConfigBootstrapper.createInstance(mapperConfig.getMapperClass()));
            }
            catch (ClassNotFoundException e) {
                throw new PHPPluginBootstrapException("Mapper class " + mapperConfig.getMapperClass() + " not found", e);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new PHPPluginBootstrapException("Mapper class must have default public constructor", e);
            }
            catch (InvocationTargetException e) {
                throw new PHPPluginBootstrapException("Mapper constructor throws exception", e);
            }
            catch (InstantiationException e) {
                throw new PHPPluginBootstrapException("Failed to instance mapper of class " + mapperConfig.getMapperClass(), e);
            }
            catch (ClassCastException e) {
                throw new PHPPluginBootstrapException("Class " + mapperConfig.getMapperClass() + " is not instance of " + Mapper.class.getCanonicalName(), e);
            }
        }
        boolean enableConnectorsInitOnStartup = PROPERTY_TRUE_VALUE.equals(this.startupProperties.getProperty(PROPERTY_CONNECTORS_FORCE_ENABLED));
        this.configureConnectors(enableConnectorsInitOnStartup);
    }

    private void updatePlugin() {
        this.configureConnectors(false);
    }

    void destroyPlugin() {
        this.connectorsRegistry.disableAllConnectors();
    }

    private void configureConnectors(boolean forceEnable) {
        for (ConnectorConfig connectorConfig : this.config.getConnectors()) {
            if (!this.connectorsRegistry.connectorExists(connectorConfig.getConnectorClass())) {
                Connector connector = null;
                try {
                    connector = this.createConnector(connectorConfig, this.listener);
                }
                catch (ClassNotFoundException e) {
                    log.error("Connector class " + connectorConfig.getConnectorClass() + " not found", (Throwable)e);
                }
                catch (IllegalAccessException | NoSuchMethodException e) {
                    log.error("Connector class must have default public constructor", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    log.error("Connector constructor throws exception", (Throwable)e);
                }
                catch (InstantiationException e) {
                    log.error("Failed to instance connector of class " + connectorConfig.getConnectorClass(), (Throwable)e);
                }
                catch (ClassCastException e) {
                    log.error("Class " + connectorConfig.getConnectorClass() + " is not instance of " + Connector.class.getCanonicalName(), (Throwable)e);
                }
                this.connectorsRegistry.addConnector(connector);
            }
            if (forceEnable || connectorConfig.isEnabled()) {
                Properties connectorProperties = new Properties();
                connectorProperties.putAll(connectorConfig.getConnectorProperties());
                try {
                    this.connectorsRegistry.enableConnector(connectorConfig.getConnectorClass(), connectorProperties);
                }
                catch (ConnectorInitException e) {
                    log.error("Failed to init connector " + connectorConfig.getConnectorClass(), (Throwable)e);
                }
                continue;
            }
            this.connectorsRegistry.disableConnector(connectorConfig.getConnectorClass());
        }
    }

    class ConfigChangedNotifierImpl
    implements ConfigChangedNotifier {
        ConfigChangedNotifierImpl() {
        }

        @Override
        public void notifyConfigChanged() {
            ConfigBootstrapper.this.updatePlugin();
        }
    }
}

