/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.extensions.php;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.anotheria.extensions.php.connectors.Connector;
import net.anotheria.extensions.php.exceptions.ConnectorInitException;

public class ConnectorsRegistry {
    private Map<String, ConnectorEntry> connectors = new HashMap<String, ConnectorEntry>();

    public void addConnector(Connector connector) {
        this.connectors.put(connector.getClass().getCanonicalName(), new ConnectorEntry(connector));
    }

    public boolean connectorExists(String connectorClass) {
        return this.connectors.containsKey(connectorClass);
    }

    public void enableConnector(String connectorClass, Properties connectorInitProperties) throws ConnectorInitException {
        ConnectorEntry connector = this.connectors.get(connectorClass);
        if (connector != null) {
            this.connectors.get(connectorClass).enableConnector(connectorInitProperties);
        }
    }

    public void disableConnector(String connectorClass) {
        ConnectorEntry connector = this.connectors.get(connectorClass);
        if (connector != null) {
            this.connectors.get(connectorClass).disableConnector();
        }
    }

    public void disableAllConnectors() {
        for (ConnectorEntry connectorEntry : this.connectors.values()) {
            connectorEntry.disableConnector();
        }
    }

    private class ConnectorEntry {
        private Connector connector;
        private boolean isEnabled = false;

        private ConnectorEntry(Connector connector) {
            this.connector = connector;
        }

        private void enableConnector(Properties initProperties) throws ConnectorInitException {
            if (!this.isEnabled) {
                this.connector.init(initProperties);
                this.isEnabled = true;
            }
        }

        private void disableConnector() {
            if (this.isEnabled) {
                this.connector.deinit();
                this.isEnabled = false;
            }
        }
    }
}

