/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.extensions.php.mappers;

import java.util.Map;
import net.anotheria.extensions.php.dto.PHPProducerDTO;
import net.anotheria.extensions.php.dto.PHPStatsDTO;
import net.anotheria.extensions.php.exceptions.MappingException;
import net.anotheria.extensions.php.mappers.Mapper;
import net.anotheria.extensions.php.mappers.StatsValues;
import net.anotheria.moskito.core.dynamic.IOnDemandStatsFactory;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducer;
import net.anotheria.moskito.core.dynamic.OnDemandStatsProducerException;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.IProducerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOnDemandStatsProducerMapper<S extends IStats>
implements Mapper {
    private static final Logger log = LoggerFactory.getLogger(AbstractOnDemandStatsProducerMapper.class);
    private Class<S> statsClass;

    public abstract void updateStats(S var1, StatsValues var2) throws MappingException;

    public abstract IOnDemandStatsFactory<S> getStatsFactory();

    public AbstractOnDemandStatsProducerMapper(Class<S> statsClass) {
        this.statsClass = statsClass;
    }

    private OnDemandStatsProducer<S> safeCastProducer(IStatsProducer producer) throws ClassCastException {
        OnDemandStatsProducer onDemandStatsTypedProducer = (OnDemandStatsProducer)producer;
        if (!this.statsClass.isInstance(onDemandStatsTypedProducer.getDefaultStats())) {
            throw new ClassCastException("Producer do not have generic type of " + this.statsClass.getCanonicalName() + " required by mapper");
        }
        return onDemandStatsTypedProducer;
    }

    @Override
    public void mapProducer(IProducerRegistry producerRegistry, PHPProducerDTO producerDTO) throws MappingException {
        OnDemandStatsProducer producer;
        log.debug("Starting to map producer with id '{}'...", (Object)producerDTO.getProducerId());
        IStatsProducer producerUncasted = producerRegistry.getProducer(producerDTO.getProducerId());
        if (producerUncasted != null) {
            try {
                producer = this.safeCastProducer(producerUncasted);
            }
            catch (ClassCastException e) {
                throw new MappingException("Cannot update producer data. Producer with id '" + producerDTO.getProducerId() + "' actual type is differs from mapper requirements type.", e);
            }
        } else {
            log.debug("Producer with id '{}' is not found in repository. Creating new producer with category '{}', subsystem '{}' and stats class '{}'...", new Object[]{producerDTO.getProducerId(), producerDTO.getCategory(), producerDTO.getSubsystem(), this.statsClass.getName()});
            producer = new OnDemandStatsProducer(producerDTO.getProducerId(), producerDTO.getCategory(), producerDTO.getSubsystem(), this.getStatsFactory());
            producerRegistry.registerProducer((IStatsProducer)producer);
        }
        for (PHPStatsDTO statsDTO : producerDTO.getStats()) {
            try {
                StatsValues statsValues = new StatsValues((Map<? extends String, String>)statsDTO.getValues());
                this.updateStats(producer.getStats(statsDTO.getName()), statsValues);
                this.updateStats(producer.getDefaultStats(), statsValues);
            }
            catch (OnDemandStatsProducerException e) {
                log.error("Failed to get stats with name '" + statsDTO.getName() + "' from producer", (Throwable)e);
            }
            catch (IllegalArgumentException | MappingException e) {
                log.error("Failed to map stats with name '" + statsDTO.getName() + "'", (Throwable)e);
            }
        }
    }
}

