/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.extensions.php.stats;

import net.anotheria.moskito.core.predefined.RequestOrientedStats;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.moskito.core.stats.StatValue;
import net.anotheria.moskito.core.stats.impl.StatValueFactory;

public class PHPScriptExecutionStats
extends RequestOrientedStats {
    private StatValue maxMemoryUsage;
    private StatValue minMemoryUsage;
    private StatValue lastMemoryUsage;
    private StatValue totalMemoryUsage;

    public PHPScriptExecutionStats(String url, Interval[] aSelectedIntervals) {
        super(url, aSelectedIntervals);
        Long longPattern = 0L;
        this.maxMemoryUsage = StatValueFactory.createStatValue((Object)longPattern, (String)"maxMemoryUsage", (Interval[])aSelectedIntervals);
        this.minMemoryUsage = StatValueFactory.createStatValue((Object)longPattern, (String)"minMemoryUsage", (Interval[])aSelectedIntervals);
        this.lastMemoryUsage = StatValueFactory.createStatValue((Object)longPattern, (String)"lastMemoryUsage", (Interval[])aSelectedIntervals);
        this.totalMemoryUsage = StatValueFactory.createStatValue((Object)longPattern, (String)"totalMemoryUsage", (Interval[])aSelectedIntervals);
        this.minMemoryUsage.setDefaultValueAsLong(Long.MAX_VALUE);
        this.minMemoryUsage.reset();
        this.maxMemoryUsage.setDefaultValueAsLong(Long.MIN_VALUE);
        this.maxMemoryUsage.reset();
        this.addStatValues(new StatValue[]{this.maxMemoryUsage, this.minMemoryUsage, this.lastMemoryUsage, this.totalMemoryUsage});
    }

    public void addMemoryUsage(long memoryUsed) {
        this.totalMemoryUsage.increaseByLong(memoryUsed);
        this.minMemoryUsage.setValueIfLesserThanCurrentAsLong(memoryUsed);
        this.maxMemoryUsage.setValueIfGreaterThanCurrentAsLong(memoryUsed);
    }

    public double getAverageMemoryUsage(String intervalName) {
        return this.totalMemoryUsage.getValueAsDouble(intervalName) / (double)this.getTotalRequests(intervalName);
    }

    public long getMaxMemoryUsage() {
        return this.maxMemoryUsage.getValueAsLong();
    }

    public long getMinMemoryUsage() {
        return this.minMemoryUsage.getValueAsLong();
    }

    public long getLastMemoryUsage() {
        return this.lastMemoryUsage.getValueAsLong();
    }
}

