/*
 * Copyright (c) 2018, apexes.net. All rights reserved.
 *
 *         http://www.apexes.net
 *
 */
package net.apexes.commons.lang;

import java.util.HashMap;
import java.util.Map;

/**
 * 
 * @author <a href="mailto:hedyn@foxmail.com">HeDYn</a>
 *
 */
public class I18Ns {

    private static final Map<String, String> CURRENCY_SYMBOL = new HashMap<>();
    static {
        CURRENCY_SYMBOL.put("CNY", "¥");//人民币
        CURRENCY_SYMBOL.put("EUR", "€");//欧元
        CURRENCY_SYMBOL.put("GBP", "£");//英镑
        CURRENCY_SYMBOL.put("JPY", "¥");//日元
        CURRENCY_SYMBOL.put("KRW", "₩");//韩元
        CURRENCY_SYMBOL.put("VND", "₫");//越南盾
        CURRENCY_SYMBOL.put("LAK", "₭");//老挝基普
        CURRENCY_SYMBOL.put("PHP", "₱");//菲律宾比索
        CURRENCY_SYMBOL.put("THB", "฿");//泰铢
        CURRENCY_SYMBOL.put("KHR", "៛");//柬埔寨瑞尔
    }
    
    public static String currencySymbol(String currencyCode) {
        String symbol = CURRENCY_SYMBOL.get(currencyCode);
        return symbol == null ? "$" : symbol;
    }

}
