/*
 * Copyright (c) 2018, apexes.net. All rights reserved.
 *
 *         http://www.apexes.net
 *
 */
package net.apexes.commons.lang;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

/**
 * @author <a href="mailto:hedyn@foxmail.com">HeDYn</a>
 */
public final class Secrets {
    private Secrets() {
    }

    /**
     * 获取字符数组的MD5码
     *
     * @param bytes 字符数组
     * @return 返回给定字符数组的MD5码
     */
    public static byte[] md5(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(bytes);
            return md.digest();
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 获取字符串的MD5码
     *
     * @param text 字符串
     * @return 返回给定字符串的MD5码
     */
    public static byte[] md5(String text) {
        return md5(text, "utf-8");
    }

    /**
     * 获取字符串的MD5码
     *
     * @param text 字符串
     * @param charsetName 字符串的编码方式
     * @return 返回字符串的MD5码
     */
    public static byte[] md5(String text, String charsetName) {
        try {
            return md5(text.getBytes(charsetName));
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
    
    /**
     * 获取字符数组的Base58编码MD5码
     *
     * @param bytes 字符数组
     * @return 返回字符数组的Base58编码MD5码
     */
    public static String md5Base58String(byte[] bytes) {
        return Base58.encode(md5(bytes));
    }
    
    /**
     * 获取字符串的Base58编码MD5码
     *
     * @param text 字符串
     * @return 返回给定字符串的Base58编码MD5码
     */
    public static String md5Base58String(String text) {
        return Base58.encode(md5(text));
    }
    
    /**
     * 获取字符串的Base58编码MD5码
     *
     * @param text 字符串
     * @param charsetName 字符串的编码方式
     * @return 返回字符串的Base58编码MD5码
     */
    public static String md5Base58String(String text, String charsetName) {
        return Base58.encode(md5(text, charsetName));
    }

    /**
     * 获取字符数组的Hex编码MD5码
     *
     * @param bytes 字符数组
     * @return 返回字符数组的Hex编码MD5码
     */
    public static String md5HexString(byte[] bytes) {
        return Bytes.toHex(md5(bytes));
    }

    /**
     * 获取字符串的Hex编码MD5码
     *
     * @param text 字符串
     * @return 返回给定字符串的Hex编码MD5码
     */
    public static String md5HexString(String text) {
        return Bytes.toHex(md5(text));
    }

    /**
     * 获取字符串的Hex编码MD5码
     *
     * @param text 字符串
     * @param charsetName 字符串的编码方式
     * @return 返回字符串的Hex编码MD5码
     */
    public static String md5HexString(String text, String charsetName) {
        return Bytes.toHex(md5(text, charsetName));
    }

    /**
     * 获取字符数组的SHA1码
     *
     * @param bytes 字符数组
     * @return 返回字符数组的SHA1码
     */
    public static byte[] sha1(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(bytes);
            return md.digest();
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 获取字符串的SHA1码
     *
     * @param text 字符串
     * @return 返回字符串的SHA1码
     */
    public static byte[] sha1(String text) {
        return sha1(text, "utf-8");
    }

    /**
     * 获取字符串的SHA1码
     *
     * @param text 字符串
     * @param charsetName 字符串的编码方式
     * @return 返回字符串的SHA1码
     */
    public static byte[] sha1(String text, String charsetName) {
        try {
            return sha1(text.getBytes(charsetName));
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 获取字符数组的Hex格式SHA1码
     *
     * @param bytes 字符数组
     * @return 返回字符数组的Hex格式SHA1码
     */
    public static String sha1HexString(byte[] bytes) {
        return Bytes.toHex(sha1(bytes));
    }

    /**
     * 获取字符串的Hex格式SHA1码
     *
     * @param text 字符串
     * @return 返回字符串的Hex格式SHA1码
     */
    public static String sha1HexString(String text) {
        return Bytes.toHex(sha1(text));
    }

    /**
     * 获取字符串的Hex格式SHA1码
     *
     * @param text 字符串
     * @param charsetName 字符串的编码方式
     * @return 返回字符串的Hex格式SHA1码
     */
    public static String sha1HexString(String text, String charsetName) {
        return Bytes.toHex(sha1(text, charsetName));
    }
    
    /**
     * 获取字符数组的Base58编码SHA1码
     *
     * @param bytes 字符数组
     * @return 返回字符数组的Base58编码SHA1码
     */
    public static String sha1Base58String(byte[] bytes) {
        return Base58.encode(sha1(bytes));
    }
    
    /**
     * 获取字符串的Base58编码SHA1码
     *
     * @param text 字符串
     * @return 返回字符串的Base58编码SHA1码
     */
    public static String sha1Base58String(String text) {
        return Base58.encode(sha1(text));
    }
    
    /**
     * 获取字符串的Base58编码SHA1码
     *
     * @param text 字符串
     * @param charsetName 字符串的编码方式
     * @return 返回字符串的Base58编码SHA1码
     */
    public static String sha1Base58String(String text, String charsetName) {
        return Base58.encode(sha1(text, charsetName));
    }

    /**
     * AES加密
     * @param content 要加密的内容
     * @param key 密钥
     * @return 返回加密后的内容
     */
    public static byte[] encryptByAES(byte[] content, byte[] key) {
        try {
            byte[] encodedKey = encodedKeyByAES(key);
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(Cipher.ENCRYPT_MODE, new SecretKeySpec(encodedKey, "AES"));
            return cipher.doFinal(content);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * AES解密
     * @param content 要解密的内容
     * @param key 密钥
     * @return 返回解密后的内容
     */
    public static byte[] decryptByAES(byte[] content, byte[] key) {
        try {
            byte[] encodedKey = encodedKeyByAES(key);
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(Cipher.DECRYPT_MODE, new SecretKeySpec(encodedKey, "AES"));
            return cipher.doFinal(content);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] encodedKeyByAES(byte[] key) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.setSeed(key);
        kgen.init(128, random);
        SecretKey secretKey = kgen.generateKey();
        return secretKey.getEncoded();
    }
}
