/*
 * Copyright (c) 2018, apexes.net. All rights reserved.
 *
 *         http://www.apexes.net
 *
 */
package net.apexes.commons.net;

import net.apexes.commons.lang.Checks;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import java.net.URLEncoder;
import java.util.Map;

/**
 *
 * @author <a href=mailto:hedyn@foxmail.com>HeDYn</a>
 */
public class NameValuePairPoster {

    public static final String CONTENT_TYPE = "application/x-www-form-urlencoded";

    private final StringHttpCaller caller;

    public NameValuePairPoster(String url) {
        this.caller = new StringHttpCaller(url, CONTENT_TYPE);
    }

    public NameValuePairPoster setConnectTimeout(int timeout) {
        caller.setConnectTimeout(timeout);
        return this;
    }

    public NameValuePairPoster setReadTimeout(int timeout) {
        caller.setReadTimeout(timeout);
        return this;
    }

    public NameValuePairPoster setSslContext(SSLContext sslContext) {
        caller.setSslContext(sslContext);
        return this;
    }

    public NameValuePairPoster setHostNameVerifier(HostnameVerifier hostNameVerifier) {
        caller.setHostNameVerifier(hostNameVerifier);
        return this;
    }

    public NameValuePairPoster setHttpProperty(String key, String value) {
        caller.setHttpProperty(key, value);
        return this;
    }

    public NameValuePairPoster setRequestLogger(StringHttpCaller.CallLogger requestLogger) {
        caller.setRequestLogger(requestLogger);
        return this;
    }

    public NameValuePairPoster setResponseLogger(StringHttpCaller.CallLogger responseLogger) {
        caller.setResponseLogger(responseLogger);
        return this;
    }

    public NameValuePairPoster setRequestEncoder(StringHttpCaller.RequestEncoder requestEncoder) {
        caller.setRequestEncoder(requestEncoder);
        return this;
    }

    public NameValuePairPoster setResponseReader(StringHttpCaller.ResponseReader responseReader) {
        caller.setResponseReader(responseReader);
        return this;
    }

    public String post(Map<String, String> request) throws Exception {
        return post(request, "utf-8");
    }

    public String post(Map<String, String> request, String enc) throws Exception {
        Checks.verifyNotNull(request, "request");

        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : request.entrySet()) {
            String key = URLEncoder.encode(entry.getKey(), enc);
            String value = URLEncoder.encode(entry.getValue(), enc);
            if (sb.length() > 0) {
                sb.append('&');
            }
            sb.append(key);
            if (value != null) {
                sb.append('=');
                sb.append(value);
            }
        }

        return caller.doPost(sb.toString());
    }

    public static NameValuePairPoster forRequest(String url) {
        return new NameValuePairPoster(url);
    }

}
