/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.i18n;

import java.util.Locale;
import net.apexes.commons.i18n.I18nMsg;
import net.apexes.commons.i18n.I18nResource;
import net.apexes.commons.lang.Enume;

public final class EnumMsg {
    private final I18nMsg msg;

    public EnumMsg(I18nResource resource) {
        this.msg = new I18nMsg(resource);
    }

    public EnumMsg(I18nResource resource, I18nMsg.Logger logger) {
        this.msg = new I18nMsg(resource, logger);
    }

    public Locale getLocale() {
        return this.msg.getLocale();
    }

    public String getEnumName(Enum<?> theEnum) {
        if (theEnum == null) {
            return null;
        }
        return this.getEnumName((Enume)((Object)theEnum), theEnum.name());
    }

    public String getEnumName(Enum<?> theEnum, String defaultValue) {
        Class<?> enumClass = theEnum.getClass();
        String key = enumClass.isMemberClass() ? enumClass.getDeclaringClass().getSimpleName() + "." + enumClass.getSimpleName() + "." + theEnum.name() : enumClass.getSimpleName() + "." + theEnum.name();
        return this.msg.getMessage(key, defaultValue);
    }

    public <T extends Enume<?>> String getEnumName(T theEnume) {
        if (theEnume == null) {
            return null;
        }
        return this.getEnumName(theEnume, this.enumNameOrValue(theEnume));
    }

    public <T extends Enume<?>> String getEnumName(T theEnume, String defaultValue) {
        Class<?> enumClass = theEnume.getClass();
        String enumeName = this.enumNameOrValue(theEnume);
        String key = enumClass.isMemberClass() ? enumClass.getDeclaringClass().getSimpleName() + "." + enumClass.getSimpleName() + "." + enumeName : enumClass.getSimpleName() + "." + enumeName;
        return this.msg.getMessage(key, defaultValue);
    }

    private <T extends Enume<?>> String enumNameOrValue(T theEnume) {
        String enumeName = theEnume.name();
        if (enumeName == null) {
            enumeName = String.valueOf(theEnume.value());
        }
        return enumeName;
    }
}

