/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.apexes.commons.lang.Checks;
import net.apexes.commons.lang.Enume;

public final class Beans {
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private static final String IS_PREFIX = "is";

    private Beans() {
    }

    public static void setPropertyValue(Object bean, String propertyName, Object value) throws Exception {
        Class<?> paramType;
        bean = Checks.verifyNotNull(bean, "bean");
        propertyName = Checks.verifyNotNull(propertyName, "propertyName");
        Class<?> classType = bean.getClass();
        if (value != null) {
            paramType = value.getClass();
        } else {
            Method getter = Beans.findGetter(classType, propertyName);
            if (getter == null) {
                throw new NoSuchMethodException(SET_PREFIX + Beans.capitalize(propertyName) + "(Void)");
            }
            paramType = getter.getReturnType();
        }
        Method setter = Beans.findSetter(classType, propertyName, paramType);
        if (setter == null) {
            throw new NoSuchMethodException(SET_PREFIX + Beans.capitalize(propertyName) + "(" + paramType + ")");
        }
        setter.invoke(bean, value);
    }

    public static Object getPropertyValue(Object bean, String propertyName) throws Exception {
        bean = Checks.verifyNotNull(bean, "bean");
        propertyName = Checks.verifyNotNull(propertyName, "propertyName");
        Class<?> classType = bean.getClass();
        Method method = Beans.findGetter(classType, propertyName);
        if (method == null) {
            throw new NoSuchMethodException();
        }
        return method.invoke(bean, (Object[])null);
    }

    public static Map<String, Object> getPropertiesValues(Object bean) {
        Method[] methods;
        bean = Checks.verifyNotNull(bean, "bean");
        HashMap<String, Object> result = new HashMap<String, Object>();
        Class<?> clazz = bean.getClass();
        for (Method method : methods = clazz.getMethods()) {
            Field field;
            String fieldName = null;
            String methodName = method.getName();
            if (methodName.startsWith(GET_PREFIX)) {
                fieldName = methodName.substring(3);
            } else if (methodName.startsWith(IS_PREFIX) && Boolean.TYPE != method.getReturnType()) {
                fieldName = methodName.substring(2);
            }
            if (fieldName == null || (field = Beans.findField(clazz, fieldName = Beans.uncapitalize(fieldName))) == null) continue;
            try {
                Object value = method.invoke(bean, (Object[])null);
                result.put(fieldName, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static BeanCopier copier() {
        return new BeanCopier();
    }

    public static void copyProperties(Object source, Object target, String ... ignoreProperties) throws Exception {
        Beans.copyProperties(source, target, null, ignoreProperties);
    }

    public static void copyProperties(Object source, Object target, FieldConverter converter, String ... ignoreProperties) throws Exception {
        source = Checks.verifyNotNull(source, "source");
        target = Checks.verifyNotNull(target, "target");
        HashSet<String> ignores = new HashSet<String>();
        if (ignoreProperties != null) {
            for (String ignore : ignoreProperties) {
                ignores.add(ignore);
            }
        }
        HashMap<String, Method> targetMethodMap = new HashMap<String, Method>();
        Class<?> targetClass = target.getClass();
        for (Method method : targetClass.getMethods()) {
            if (method.getParameterTypes().length != 1) continue;
            String fieldName = null;
            String methodName = method.getName();
            if (methodName.startsWith(SET_PREFIX)) {
                fieldName = methodName.substring(3);
            }
            if (fieldName == null || ignores.contains(Beans.uncapitalize(fieldName))) continue;
            targetMethodMap.put(fieldName, method);
        }
        Class<?> sourceClass = source.getClass();
        for (Method method : sourceClass.getMethods()) {
            Method setter;
            String fieldName = null;
            String methodName = method.getName();
            if (methodName.startsWith(GET_PREFIX)) {
                fieldName = methodName.substring(3);
            } else if (methodName.startsWith(IS_PREFIX) && Boolean.TYPE != method.getReturnType()) {
                fieldName = methodName.substring(2);
            }
            if (fieldName == null || (setter = (Method)targetMethodMap.get(fieldName)) == null) continue;
            try {
                Object value = method.invoke(source, new Object[0]);
                if (converter != null) {
                    value = converter.convert(value, method, setter);
                }
                setter.invoke(target, value);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Could not copy property from source to target:" + Beans.uncapitalize(fieldName), ex);
            }
        }
    }

    private static Method findGetter(Class<?> classType, String propertyName) {
        propertyName = Beans.capitalize(propertyName);
        Method method = null;
        try {
            method = classType.getMethod(GET_PREFIX + propertyName, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (method == null) {
            try {
                method = classType.getMethod(IS_PREFIX + propertyName, null);
                Class<?> returnType = method.getReturnType();
                if (Boolean.TYPE != returnType) {
                    method = null;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return method;
    }

    private static Method findSetter(Class<?> classType, String propertyName, Class<?> paramType) {
        propertyName = Beans.capitalize(propertyName);
        Method method = null;
        try {
            method = classType.getMethod(SET_PREFIX + propertyName, paramType);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return method;
    }

    private static Field findField(Class<?> clazz, String fieldName) {
        if (clazz == Object.class) {
            return null;
        }
        try {
            Field field = clazz.getDeclaredField(fieldName);
            if (field != null) {
                return field;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Beans.findField(clazz.getSuperclass(), fieldName);
    }

    public static String capitalize(String name) {
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1))) {
            return name;
        }
        if (name.length() > 1) {
            return Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
        return name.toUpperCase();
    }

    public static String uncapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static boolean isAccessorPresent(String prefix, String property, Class<?> bean) {
        try {
            bean.getMethod(prefix + Beans.capitalize(property), new Class[0]);
            return true;
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
    }

    public static Method getAccessor(String prefix, String property, Class<?> bean) {
        try {
            return bean.getMethod(prefix + Beans.capitalize(property), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static interface FieldConverter {
        public Object convert(Object var1, Method var2, Method var3);
    }

    public static interface Converter<S, T> {
        public T convert(S var1);
    }

    private static class ValueToEnumeConverter<V extends Comparable<V>, E extends Enume<V>>
    implements Converter<V, E> {
        private final Class<E> enumeClass;

        private ValueToEnumeConverter(Class<E> enumeClass) {
            this.enumeClass = enumeClass;
        }

        @Override
        public E convert(V source) {
            return Enume.valueOf(this.enumeClass, source);
        }
    }

    private static class EnumeToValueConverter
    implements Converter<Enume, Comparable> {
        private EnumeToValueConverter() {
        }

        @Override
        public Comparable convert(Enume source) {
            return source.value();
        }
    }

    public static class ConverterHolder<S, T> {
        private final Class<S> sourceClass;
        private final Class<T> targetClass;
        private final Converter<S, T> converter;

        public ConverterHolder(Class<S> sourceClass, Class<T> targetClass, Converter<S, T> converter) {
            this.sourceClass = sourceClass;
            this.targetClass = targetClass;
            this.converter = converter;
        }

        protected boolean isMatching(Method sourceMethod, Method targetMethod) {
            Class<?> sourceType = sourceMethod.getReturnType();
            Class<?> targetType = targetMethod.getParameterTypes()[0];
            return this.sourceClass.isAssignableFrom(sourceType) && this.targetClass.isAssignableFrom(targetType);
        }

        protected Object convert(Object source) {
            return this.converter.convert(source);
        }
    }

    public static class TargetHolder<S, T> {
        private final BeanCopier copier;
        private final Class<S> sourceClass;
        private final Class<T> targetClass;

        private TargetHolder(BeanCopier copier, Class<S> sourceClass, Class<T> targetClass) {
            this.copier = copier;
            this.sourceClass = sourceClass;
            this.targetClass = targetClass;
        }

        public BeanCopier with(Converter<S, T> converter) {
            Checks.verifyNotNull(converter, "converter");
            this.copier.addConverterHolder(new ConverterHolder<S, T>(this.sourceClass, this.targetClass, converter));
            return this.copier;
        }
    }

    public static class SourceHolder<S> {
        private final BeanCopier copier;
        private final Class<S> sourceClass;

        private SourceHolder(BeanCopier copier, Class<S> sourceClass) {
            this.copier = copier;
            this.sourceClass = sourceClass;
        }

        public <T> TargetHolder<S, T> to(Class<T> targetClass) {
            Checks.verifyNotNull(targetClass, "targetClass");
            return new TargetHolder(this.copier, this.sourceClass, targetClass);
        }
    }

    public static class BeanCopier {
        private final List<ConverterHolder<?, ?>> converterHolders;
        private final FieldConverter fieldConverter = new FieldConverter(){

            @Override
            public Object convert(Object sourceValue, Method sourceMethod, Method targetMethod) {
                for (int i = BeanCopier.this.converterHolders.size() - 1; i >= 0; --i) {
                    ConverterHolder holder = (ConverterHolder)BeanCopier.this.converterHolders.get(i);
                    if (!holder.isMatching(sourceMethod, targetMethod)) continue;
                    return holder.convert(sourceValue);
                }
                return sourceValue;
            }
        };

        private BeanCopier() {
            this.converterHolders = new ArrayList();
        }

        public void addConverterHolder(ConverterHolder<?, ?> holder) {
            this.converterHolders.add(holder);
        }

        public <S> SourceHolder<S> from(Class<S> sourceClass) {
            Checks.verifyNotNull(sourceClass, "sourceClass");
            return new SourceHolder(this, sourceClass);
        }

        public BeanCopier fromEnume() {
            this.from(Enume.class).to(Comparable.class).with(new EnumeToValueConverter());
            return this;
        }

        public <V extends Comparable<V>, E extends Enume<V>> BeanCopier toEnume(Class<E> enumeClass) {
            ValueToEnumeConverter converter = new ValueToEnumeConverter(enumeClass);
            this.addConverterHolder(new ConverterHolder<Comparable, E>(Comparable.class, enumeClass, converter));
            return this;
        }

        public BeanCopier toEnumes(Collection<Class<? extends Enume<?>>> enumeClasses) {
            for (Class<Enume<?>> clazz : enumeClasses) {
                ValueToEnumeConverter converter = new ValueToEnumeConverter(clazz);
                this.addConverterHolder(new ConverterHolder(Comparable.class, clazz, converter));
            }
            return this;
        }

        public void copy(Object source, Object target, String ... ignoreProperties) throws Exception {
            Beans.copyProperties(source, target, this.fieldConverter, ignoreProperties);
        }
    }
}

