/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class Comparators {
    public static <T> ComparatorHelper<T> orderBy(Getter<T> getter) {
        return new ComparatorHelper<T>().orderBy(getter);
    }

    public static <T> ComparatorHelper<T> orderBy(Getter<T> getter, boolean asc) {
        return new ComparatorHelper<T>().orderBy(getter, asc);
    }

    public static <T> ComparatorHelper<T> ascBy(Getter<T> getter) {
        return Comparators.orderBy(getter, true);
    }

    public static <T> ComparatorHelper<T> descBy(Getter<T> getter) {
        return Comparators.orderBy(getter, false);
    }

    public static <T> void sort(List<T> list, Getter<T> getter) {
        Comparators.orderBy(getter).sort(list);
    }

    public static <T> void sort(List<T> list, Getter<T> getter, boolean asc) {
        Comparators.orderBy(getter, asc).sort(list);
    }

    public static <T> void sortNullLast(List<T> list, Getter<T> getter) {
        Comparators.orderBy(getter).nullLast().sort(list);
    }

    public static <T> void sortNullLast(List<T> list, Getter<T> getter, boolean asc) {
        Comparators.orderBy(getter, asc).nullLast().sort(list);
    }

    public static <T> void ascSort(List<T> list, Getter<T> getter) {
        Comparators.sort(list, getter, true);
    }

    public static <T> void descSort(List<T> list, Getter<T> getter) {
        Comparators.sort(list, getter, false);
    }

    public static <T> void ascSortNullLast(List<T> list, Getter<T> getter) {
        Comparators.sortNullLast(list, getter, true);
    }

    public static <T> void descSortNullLast(List<T> list, Getter<T> getter) {
        Comparators.sortNullLast(list, getter, false);
    }

    public static <T extends Comparable<T>> int compare(T o1, T o2) {
        return Comparators.doCompare(o1, o2, false);
    }

    public static <T extends Comparable<T>> int nullLastCompare(T o1, T o2) {
        return Comparators.doCompare(o1, o2, true);
    }

    private static int doCompare(Comparable o1, Comparable o2, boolean nullLast) {
        int v = Comparators.compareNull(o1, o2, nullLast);
        if (v == 0 && o1 != null && o2 != null) {
            v = o1.compareTo(o2);
        }
        if (v < 0) {
            return -1;
        }
        if (v > 0) {
            return 1;
        }
        return 0;
    }

    private static <T> int compareNull(T o1, T o2, boolean nullLast) {
        if (o1 == null) {
            if (o2 != null) {
                return nullLast ? 1 : -1;
            }
        } else if (o2 == null) {
            return nullLast ? -1 : 1;
        }
        return 0;
    }

    public static int versionCompare(String version1, String version2) {
        if (version1 == null) {
            if (version2 == null) {
                return 0;
            }
            return -1;
        }
        if (version2 == null) {
            return 1;
        }
        StringTokenizer t1 = new StringTokenizer(version1, "._");
        StringTokenizer t2 = new StringTokenizer(version2, "._");
        while (t1.hasMoreTokens()) {
            int n2;
            if (!t2.hasMoreTokens()) {
                return 1;
            }
            int n1 = Integer.parseInt(t1.nextToken());
            int d = n1 - (n2 = Integer.parseInt(t2.nextToken()));
            if (d == 0) continue;
            return d;
        }
        return t2.hasMoreTokens() ? -1 : 0;
    }

    public static interface Getter<T> {
        public Comparable<?> apply(T var1);
    }

    private static class GetterEntry<T> {
        final Getter<T> getter;
        final boolean asc;

        GetterEntry(Getter<T> getter) {
            this(getter, true);
        }

        GetterEntry(Getter<T> getter, boolean asc) {
            this.getter = getter;
            this.asc = asc;
        }
    }

    public static class ComparatorHelper<T>
    implements Comparator<T> {
        private final List<GetterEntry<T>> entries = new ArrayList<GetterEntry<T>>();
        private boolean nullLast = false;

        private ComparatorHelper() {
        }

        public ComparatorHelper<T> orderBy(Getter<T> getter) {
            this.entries.add(new GetterEntry<T>(getter));
            return this;
        }

        public ComparatorHelper<T> orderBy(Getter<T> getter, boolean asc) {
            this.entries.add(new GetterEntry<T>(getter, asc));
            return this;
        }

        public ComparatorHelper<T> ascBy(Getter<T> getter) {
            return this.orderBy(getter, true);
        }

        public ComparatorHelper<T> descBy(Getter<T> getter) {
            return this.orderBy(getter, false);
        }

        public ComparatorHelper<T> nullLast() {
            this.nullLast = true;
            return this;
        }

        public void sort(List<T> list) {
            Collections.sort(list, this);
        }

        @Override
        public int compare(T o1, T o2) {
            int v;
            block1: {
                GetterEntry<T> entry;
                v = Comparators.compareNull(o1, o2, this.nullLast);
                if (v != 0) break block1;
                Iterator<GetterEntry<T>> iterator = this.entries.iterator();
                while (iterator.hasNext() && (v = this.compare(entry = iterator.next(), o1, o2)) == 0) {
                }
            }
            return v;
        }

        private int compare(GetterEntry<T> entry, T o1, T o2) {
            Comparable<?> c1 = entry.getter.apply(o1);
            Comparable<?> c2 = entry.getter.apply(o2);
            int v = Comparators.doCompare(c1, c2, this.nullLast);
            if (entry.asc) {
                return v;
            }
            return -v;
        }
    }
}

