/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class Dates {
    private Dates() {
    }

    public static long networkTimeMillis() throws IOException {
        return Dates.networkTimeMillis("http://www.baidu.com", "http://www.google.com", "http://www.taobao.com");
    }

    public static long networkTimeMillis(String ... urls) throws IOException {
        return Dates.networkTimeMillis(3, urls);
    }

    public static long networkTimeMillis(int connectTimeout, String ... urls) throws IOException {
        IOException exception = null;
        for (String webUrl : urls) {
            try {
                URL url = new URL(webUrl);
                URLConnection uc = url.openConnection();
                if (connectTimeout > 0) {
                    uc.setConnectTimeout(connectTimeout);
                }
                uc.connect();
                long timeMs = uc.getDate();
                if (timeMs <= 0L) continue;
                return timeMs;
            }
            catch (IOException e) {
                exception = e;
            }
        }
        if (exception == null) {
            exception = new IOException("Connect failed.");
        }
        throw exception;
    }

    public static int dayDiff(Date from, Date to) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            from = df.parse(df.format(from));
            to = df.parse(df.format(to));
        }
        catch (Exception ex) {
            throw new RuntimeException();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(to);
        long toTime = calendar.getTimeInMillis() + (long)calendar.get(16);
        calendar.setTime(from);
        long fromTime = calendar.getTimeInMillis() + (long)calendar.get(16);
        long days = Math.round((double)((toTime /= 1000L) - (fromTime /= 1000L)) / 86400.0);
        return (int)days;
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 != null && date2 != null) {
            Calendar c1 = Calendar.getInstance();
            c1.setTime(date1);
            Calendar c2 = Calendar.getInstance();
            c2.setTime(date2);
            return c1.get(1) == c2.get(1) && c1.get(2) == c2.get(2) && c1.get(5) == c2.get(5);
        }
        return false;
    }

    public static boolean isDateOverlap(Date startDate1, Date endDate1, Date startDate2, Date endDate2, boolean ignoreYearS1, boolean ignoreYearE1, boolean ignoreYearS2, boolean ignoreYearE2) {
        int iEndDate2;
        int iEndDate1;
        int iStartDate2;
        int iStartDate1;
        SimpleDateFormat ymdFmt = new SimpleDateFormat("yyyyMMdd");
        SimpleDateFormat mdFmt = new SimpleDateFormat("MMdd");
        if (ignoreYearS1 != ignoreYearS2) {
            int year = ignoreYearS1 ? Dates.toYear(startDate2) : Dates.toYear(startDate1);
            iStartDate1 = Integer.valueOf(year + mdFmt.format(startDate1));
            iStartDate2 = Integer.valueOf(year + mdFmt.format(startDate2));
        } else if (ignoreYearS1) {
            iStartDate1 = Integer.valueOf("1" + mdFmt.format(startDate1));
            iStartDate2 = Integer.valueOf("1" + mdFmt.format(startDate2));
        } else {
            iStartDate1 = Integer.valueOf(ymdFmt.format(startDate1));
            iStartDate2 = Integer.valueOf(ymdFmt.format(startDate2));
        }
        if (ignoreYearE1 != ignoreYearE2) {
            int year = ignoreYearE1 ? Dates.toYear(endDate2) : Dates.toYear(endDate1);
            iEndDate1 = Integer.valueOf(year + mdFmt.format(endDate1));
            iEndDate2 = Integer.valueOf(year + mdFmt.format(endDate2));
        } else if (ignoreYearE1) {
            iEndDate1 = Integer.valueOf("1" + mdFmt.format(endDate1));
            iEndDate2 = Integer.valueOf("1" + mdFmt.format(endDate2));
        } else {
            iEndDate1 = Integer.valueOf(ymdFmt.format(endDate1));
            iEndDate2 = Integer.valueOf(ymdFmt.format(endDate2));
        }
        return iStartDate1 <= iStartDate2 && iStartDate2 <= iEndDate1 || iStartDate1 <= iEndDate2 && iEndDate2 <= iEndDate1 || iStartDate2 < iStartDate1 && iEndDate1 < iEndDate2;
    }

    private static int toYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }
}

