/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.commons.lang;

import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import net.apexes.commons.lang.Checks;
import net.apexes.commons.lang.Comparators;

public abstract class Enume<T extends Comparable<T>>
implements Comparable<Enume<T>> {
    private final T value;
    private final int ordinal;
    private String name;
    private boolean defineEnume;
    private static final EnumeCache enumeCache = new EnumeCache();

    private Enume(T value) {
        if (Enume.findConstructor(this.getClass()) == null) {
            throw new InstantiationError("Invalid enume. [" + this.getClass().getName() + ", " + value + "]");
        }
        this.value = value;
        this.ordinal = enumeCache.add(this);
        this.defineEnume = true;
    }

    public final T value() {
        return this.value;
    }

    public final int ordinal() {
        if (this.defineEnume) {
            return this.ordinal;
        }
        return -1;
    }

    public final String name() {
        if (this.defineEnume) {
            if (this.name == null) {
                Field[] fields;
                Class<?> enumeClass = this.getClass();
                for (Field field : fields = enumeClass.getFields()) {
                    if (!Enume.isEnumeField(enumeClass, field)) continue;
                    try {
                        if (field.get(enumeClass) != this) continue;
                        this.name = field.getName();
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return this.name;
        }
        return null;
    }

    public final String fullName() {
        String name = this.name();
        if (name != null) {
            return this.getClass().getSimpleName() + "." + name;
        }
        return null;
    }

    public final boolean eqValue(T value) {
        return Enume.eqValue(this, value);
    }

    public final boolean neValue(T value) {
        return !Enume.eqValue(this, value);
    }

    public final boolean isDefine() {
        return this.defineEnume;
    }

    public final boolean isUnknown() {
        return !this.isDefine();
    }

    void unknownEnume() {
        this.defineEnume = false;
    }

    void defineEnume(String name) {
        this.defineEnume = true;
        this.name = name;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Enume other = (Enume)obj;
        if (this.value == null) {
            return other.value == null;
        }
        return this.value.equals(other.value);
    }

    @Override
    public final int compareTo(Enume<T> o) {
        if (this.value == null) {
            if (o.value == null) {
                return 0;
            }
            return -1;
        }
        if (o.value == null) {
            return 1;
        }
        return this.value.compareTo(o.value);
    }

    public final String toString() {
        return String.valueOf(this.value);
    }

    public static <T extends Comparable<T>, E extends Enume<T>> boolean eqValue(E enume, T value) {
        Checks.verifyNotNull(enume, "enume");
        if (value == null) {
            return enume.value() == null;
        }
        T enumeValue = enume.value();
        return enumeValue != null && enumeValue.equals(value);
    }

    public static <T extends Comparable<T>, E extends Enume<T>> boolean eq(E enume1, E enume2) {
        if (enume1 == null) {
            return enume2 == null;
        }
        return enume2 != null && enume1.equals(enume2);
    }

    public static <T extends Comparable<T>, E extends Enume<T>> T toValue(E enume) {
        return enume == null ? null : (T)enume.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Comparable<T>, E extends Enume<T>> E fromValue(Class<E> enumeClass, T value) {
        Enume.verifyEnumeClass(enumeClass);
        EnumeCache enumeCache = Enume.enumeCache;
        synchronized (enumeCache) {
            E enume = Enume.enumeCache.getOne(enumeClass, value);
            if (enume == null) {
                enume = Enume.newEnume(enumeClass, value);
                ((Enume)enume).unknownEnume();
            }
            return enume;
        }
    }

    public static <T extends Comparable<T>, E extends Enume<T>> E valueOf(Class<E> enumeClass, Object value) {
        return Enume.fromValue(enumeClass, (Comparable)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Comparable<T>, E extends Enume<T>> Collection<E> values(Class<E> enumeClass) {
        Enume.verifyEnumeClass(enumeClass);
        EnumeCache enumeCache = Enume.enumeCache;
        synchronized (enumeCache) {
            Set<E> set = Enume.enumeCache.getAllDefind(enumeClass);
            if (set == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableCollection(set);
        }
    }

    public static <T extends Comparable<T>, E extends Enume<T>> boolean isDefine(Class<E> enumeClass, T value) {
        for (Enume enume : Enume.values(enumeClass)) {
            if (!enume.isDefine()) continue;
            return true;
        }
        return false;
    }

    public static <T extends Comparable<T>, E extends Enume<T>> boolean isUnknown(Class<E> enumeClass, T value) {
        return !Enume.isDefine(enumeClass, value);
    }

    public static <T extends Comparable<T>, E extends Enume<T>> void verifyEnumeClass(Class<E> enumeClass) {
        Checks.verifyNotNull(enumeClass, "enumeClass");
        if (enumeClass.getSuperclass() != This.class) {
            throw new IllegalArgumentException("Superclass must be Enume.$. [" + enumeClass.getName() + "]");
        }
        if (Enume.enumeValueClass(enumeClass) == null) {
            throw new IllegalArgumentException("Superclass must has actual type arguments. [" + enumeClass.getName() + "]");
        }
    }

    public static Class<? extends Comparable<?>> valueClass(Class<?> classType) {
        if (classType != null && Enume.class.isAssignableFrom(classType)) {
            return Enume.enumeValueClass(classType);
        }
        return null;
    }

    private static Class<? extends Comparable<?>> enumeValueClass(Class<?> classType) {
        try {
            Type[] types;
            ParameterizedType paramType;
            Type type = classType.getGenericSuperclass();
            if (type instanceof ParameterizedType && This.class.equals((Object)(paramType = (ParameterizedType)type).getRawType()) && (types = paramType.getActualTypeArguments())[1] == classType) {
                return (Class)types[0];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static <T extends Comparable<T>, E extends Enume<T>> Constructor<E> findConstructor(Class<E> enumeClass) {
        Constructor<E> constructor = null;
        Class<Comparable<E>> valueClass = Enume.enumeValueClass(enumeClass);
        if (valueClass != null) {
            try {
                constructor = enumeClass.getDeclaredConstructor(valueClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return constructor;
    }

    private static <T extends Comparable<T>, E extends Enume<T>> E newEnume(Class<E> enumeClass, T value) {
        Exception exception = null;
        try {
            Constructor<E> constructor = Enume.findConstructor(enumeClass);
            if (constructor != null) {
                constructor.setAccessible(true);
                return (E)((Enume)constructor.newInstance(value));
            }
        }
        catch (Exception e) {
            exception = e;
        }
        throw new RuntimeException("Invalid Enume. [" + enumeClass.getName() + ", " + value + "]", exception);
    }

    private static boolean isEnumeField(Class<?> enumeClass, Field field) {
        int m = field.getModifiers();
        return field.getType() == enumeClass && Modifier.isPublic(m) && Modifier.isStatic(m) && Modifier.isFinal(m);
    }

    private static <T> T cast(Object value) {
        return (T)value;
    }

    static void printCache(PrintStream printStream) {
        printStream.println(enumeCache);
    }

    /* synthetic */ Enume(Comparable x0, 1 x1) {
        this(x0);
    }

    private static class EnumesHolder<T extends Comparable<T>, E extends Enume<T>>
    extends WeakHashMap<E, Object> {
        private Set<E> defindSet;

        private EnumesHolder() {
        }

        void completeDefind(Set<E> defindSet) {
            this.defindSet = defindSet;
        }

        void add(E enume) {
            E e = this.find(((Enume)enume).value());
            if (e != null) {
                throw new RuntimeException("The util already exists. [" + e.getClass() + ", " + ((Enume)e).value() + "]");
            }
            this.put(enume, null);
        }

        E find(T value) {
            for (Enume e : this.keySet()) {
                if (!e.eqValue(value)) continue;
                return (E)e;
            }
            return null;
        }

        @Override
        public String toString() {
            LinkedHashMap<Enume, String> map = new LinkedHashMap<Enume, String>();
            for (Enume enume : this.keySet()) {
                map.put(enume, enume.name());
            }
            return ((Object)map).toString();
        }
    }

    private static class EnumeCache {
        private final Map<Class<?>, EnumesHolder<?, ?>> enumsFinder = new HashMap();

        private EnumeCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <T extends Comparable<T>, E extends Enume<T>> int add(E enume) {
            Map<Class<?>, EnumesHolder<?, ?>> map = this.enumsFinder;
            synchronized (map) {
                Class<?> enumeClass = enume.getClass();
                EnumesHolder holder = (EnumesHolder)Enume.cast(this.enumsFinder.get(enumeClass));
                if (holder == null) {
                    holder = new EnumesHolder();
                    this.enumsFinder.put(enumeClass, holder);
                }
                int ordinal = holder.size();
                holder.add(enume);
                return ordinal;
            }
        }

        <T extends Comparable<T>, E extends Enume<T>> Set<E> getAllDefind(Class<E> enumeClass) {
            EnumesHolder<T, E> holder = this.findHolder(enumeClass);
            if (holder != null) {
                return ((EnumesHolder)holder).defindSet;
            }
            return null;
        }

        <T extends Comparable<T>, E extends Enume<T>> E getOne(Class<E> enumeClass, T value) {
            E enume = null;
            EnumesHolder<T, E> holder = this.findHolder(enumeClass);
            if (holder != null) {
                enume = holder.find(value);
            }
            return enume;
        }

        private <T extends Comparable<T>, E extends Enume<T>> EnumesHolder<T, E> findHolder(Class<E> enumeClass) {
            EnumesHolder holder = (EnumesHolder)Enume.cast(this.enumsFinder.get(enumeClass));
            if (holder == null) {
                Field[] fields;
                LinkedHashSet<Enume> definds = new LinkedHashSet<Enume>();
                for (Field field : fields = enumeClass.getFields()) {
                    if (!Enume.isEnumeField(enumeClass, field)) continue;
                    try {
                        Enume e = (Enume)Enume.cast(field.get(enumeClass));
                        e.defineEnume(field.getName());
                        definds.add(e);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                holder = (EnumesHolder)Enume.cast(this.enumsFinder.get(enumeClass));
                holder.completeDefind(definds);
            } else if (holder.defindSet == null) {
                TreeSet<Enume> definds = new TreeSet<Enume>(new Comparator<E>(){

                    @Override
                    public int compare(E o1, E o2) {
                        return Comparators.compare(((Enume)o1).ordinal(), ((Enume)o2).ordinal());
                    }
                });
                for (Enume e : holder.keySet()) {
                    if (!e.isDefine()) continue;
                    definds.add(e);
                }
                holder.completeDefind(definds);
            }
            return holder;
        }

        public String toString() {
            return "EnumeCache [" + this.enumsFinder + "]";
        }
    }

    public static abstract class This<T extends Comparable<T>, E extends This<T, E>>
    extends Enume<T> {
        protected This(T value) {
            super((Comparable)value, null);
        }

        public final boolean eq(E enume) {
            return this.equals(enume);
        }

        public final boolean ne(E enume) {
            return !this.eq(enume);
        }
    }
}

